/*
 *  system.c
 *  
 *  General purpose routines for system-level tasks
 *  such as error reporting and memory management
 *
 *  Created by Andrew Pershing on Tue Feb 26 2002.
 *
 */

#include "system.h"

void Error(char *subrout, char *msg){
    
      printf("ERROR in function %s: \n", subrout);
      printf("       %s\n", msg);
      exit(-1);
      
  }
  
int *newarray_int(int dim1, char *sub, char *msg){
  /* returns a pointer to a new dim1 array of ints            */
  /*                                                          */
  /* Initializes array to 0                                   */

    int *ar, *ptr;
    int j;

    ar=malloc(sizeof(int)*(dim1));
    if(ar==NULL){
      Error(sub, msg);
    }
    ptr=ar;
      for(j=0; j<dim1; j++){
        *ptr=0.0;
        ptr++;
      }
    return(ar);
  }
  
double *newarray_double(int dim1, char *sub, char *msg){
  /* returns a pointer to a new dim1 array of doubles         */
  /*                                                          */
  /* Initializes array to 0                                   */

    double *ar, *ptr;
    int j;

    ar=malloc(sizeof(double)*(dim1));
    if(ar==NULL){
      Error(sub, msg);
    }
    ptr=ar;
      for(j=0; j<dim1; j++){
        *ptr=0.0;
        ptr++;
      }
    return(ar);
  }

double **new2Darray_double(int dim1, int dim2, char *sub, char *msg){
  /* returns a pointer to a new dim1-by-dim2 array of doubles */
  /*                                                          */
  /* The returned pointer can then be used as a typical 2D    */
  /* array.  This allocation scheme guarantees that the       */
  /* array is a contiguous block of memory.  The scheme is    */
  /* from the com.lang.c FAQ                                  */
  /*                                                          */
  /* Initializes array to 0                                   */
    double **ar;
    int j, k;
    char *msg2="";
    
    ar=(double **)malloc(sizeof(double *)*dim1); /* allocate a length dim1 array of pointers */
    if(ar==NULL){
      sprintf(msg2, "%s while creating row of pointers", msg);
      Error(sub, msg2);
    }
    
    ar[0]=(double *)malloc(dim1*dim2*sizeof(double));
    if(ar[0]==NULL){
      sprintf(msg2, "%s while creating %d-by-%d block of memory",
              msg, dim1,dim2);
      Error(sub, msg2);
    }
    
    for(j=1; j<dim1; j++) {
      ar[j]=ar[0]+j*dim2;
    }
    for(j=0; j<dim1; j++){
      for(k=0; k<dim2; k++){
        ar[j][k]=0.0;
      }
    }
    
    return(ar);                
    
  }

  
