/*
 *  main.c
 *  GLtest
 *
 *  Created by Andrew Pershing on Wed Apr 10 2002.
 *  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
 *
 */
 
#include "GLout.h"
#include "system.h"


double **GLC, *GLx, *GLtimes, GLmax;
int GLm, GLn, GLnT, GLtslice, WinHeight, WinWidth;




/* Init ----------------------------------------------------------------------*/

GLvoid InitGL(int Height, int Width){
                   /* R  ,   G ,  B  , alpha  */
	glClearColor(0.0, 0.0, 0.0, 0.0);		/* This Will Clear The Background Color To Black */
        glColor3f(1.0, 1.0, 1.0);  /* Set drawing color to white */
	glClearDepth(1.0);						/* Enables Clearing Of The Depth Buffer */

        glMatrixMode(GL_PROJECTION);
	glLoadIdentity();							/* Reset The Projection Matrix*/

        WinHeight=Height;
        WinWidth=Width;
	gluOrtho2D(0.0, (GLdouble)WinWidth, 0.0, (GLdouble)WinHeight);
        
}

/* DrawGLScene ---------------------------------------------------------------*/

GLvoid DrawC(GLvoid) {    
        int j,k;
        GLdouble A, B, C, D;
        double slp, slpk;
        
        
        A=WinWidth/GLx[GLm-1];
        B=0.0;
        C=WinHeight/GLmax;
        D=0.0;
        
        glClear(GL_COLOR_BUFFER_BIT); /* Clear the window */
        
        slp=1.0/GLnT;
        for(k=0;k<GLnT;k++){
            slpk=slp*k;
            glColor3f(-slpk+1.0, 0.0, slpk);
            glBegin(GL_LINE_STRIP);
                for(j=0;j<GLm;j++){
                    glVertex2d(A*((GLdouble)GLx[j])+B,C*((GLdouble)GLC[j][k])+D);
                }
            glEnd();
        }
        glFlush();/* make everything visible */
}

GLvoid ResizeIt(int width, int height)
{
    WinWidth=width;
    WinHeight=height;
    glViewport(0, 0, width, height);

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluOrtho2D(0.0, (GLdouble)WinWidth, 0.0, (GLdouble)WinHeight);
}

GLvoid EmphasizeTime(int key, int x, int y){
    if(key==GLUT_KEY_UP || key==GLUT_KEY_RIGHT){
        GLtslice=GLtslice+1;
        if(GLtslice>=GLnT){GLtslice=0;}
    }else{
        if(key==GLUT_KEY_DOWN || key==GLUT_KEY_LEFT){
            GLtslice=GLtslice-1;
            if(GLtslice<0){GLtslice=GLnT-1;}
        }
    }
    DrawC();
}
/* Allocate space for GLx and GLC */

void InitGLArrays(double *C,int m, int n, double L, double dx){
    int j;
    
    GLC=new2Darray_double(m, n, "InitGLArrays","Unable to allocate GLC");
    GLx=newarray_double(m,"InitGLArrays","Unable to allocate GLx");
    GLtimes=newarray_double(n,"InitGLArrays","Unable to allocate GLtimes");
    GLtimes[0]=0.0;
    GLn=n;
    GLm=m;
    GLnT=1;
    GLtslice=0;
    GLmax=C[0];
    for(j=0;j<m;j++){
        GLC[j][0]=C[j];
        if(C[j]>GLmax){GLmax=C[j];}
        GLx[j]=j*dx;
    }

}

void AddSample(double *C, double t){
    int j;
    if(GLnT>=GLn){
        Error("AddSample", "Too many samples");
    }
    for(j=0;j<GLm;j++){
        GLC[j][GLnT]=C[j];
        if(C[j]>GLmax){GLmax=C[j];}
    }
    GLtimes[GLnT]=t;
    GLnT=GLnT+1;
}