C Subroutines for Fpca
C
C 
		subroutine ReadData(name, m, n, C, NMAX, KMAX)
C Reads the data in name
C
C The first line of name indicates the number of rows (m)
C The second line indicates the number of columns (n)
C The remaining m*n lines contain the data values, output
C column by column
C
		   implicit none
         character*72 name
         integer m, n, NMAX, KMAX
         real C(NMAX, KMAX)

			integer j, k
         character*72 msg, sub

         OPEN(UNIT=3,FILE=name,STATUS='OLD')
         READ(3,*) m  
		   if(m.gt.NMAX)then
      	   sub='ReadData'
            msg='m>NMAX--Change NMAX and recompile'
      	   CALL Error(sub,msg)
         endif
         READ(3,*) n  
		   if(n.gt.KMAX)then
      	   sub='ReadData'
            msg='n>MAX--Change KMAX and recompile'
      	   CALL Error(sub,msg)
         endif
         do j=1,n
         	do k=1,m
            	READ(3,*) C(k,j)
            enddo
         enddo

  		   close(3)
		RETURN
      END

		subroutine PrintMat(name, C,  m,n, MMAX)
C prints the m-by-n matrix C to file called name
C
		   implicit none
         character*72 name
         integer m,n,MMAX
         real C(MMAX,*)
    	   integer j,k
		
         OPEN(UNIT=5,FILE=name,STATUS='UNKNOWN')
    	   do j=1,n
         	write(5,*)'%column ',j
         	do k=1,m
           		write(5,*)C(k,j)
            enddo
    	   enddo
    	   close(5)
			return
		end

		subroutine PrintArray(name, C,  m)
C Saves the length-m array C in a file called name */
		   implicit none
         character*72 name
         integer m
         real C(*)
    	   integer j

    	   OPEN(UNIT=3,FILE=name,STATUS='UNKNOWN')
    	   do j=1,m
           write(3,*)j,C(j)
    	   enddo
    	   close(3)
      RETURN
      END
    
    	subroutine GetCov(Cov,C,m,n, NMAX, KMAX)
C Computes the Covariance matrix Cov from m-by-n matrix C
C
C			Cov=(1/(m-1))*C'*C
C
C Cov must by at least KMAX-by-KMAX
C C must be NMAX-by-KMAX
C 
C Calls BLAS level 3 routine SSYRK to compute the 
C matrix product.  Since Cov is symmetric, only the
C upper-triangular portion is stored.
C
		implicit none
		integer m, n, NMAX, KMAX
      real Cov(KMAX,KMAX), C(NMAX,KMAX)
      
      real fac
      integer j,k
      
      fac=1.0/(real(m)-1.0)
C
C Initialize Cov
C
      do j=1,n
         do k=1,n
            Cov(j,k)=0.0
         enddo
      enddo
C
C SSYRK is a BLAS level-3 routine to compute aAA'+b*C
C or in this case,       
C
C		Cov=fac*C'*C+0*Cov
C
C The character 'u' tells SSYRK to udate only the upper
C triangular portion of Cov (which is symmetric) ('l' would
C save the lower triangular portion), and the 't' option says
C to compute A'A rather than AA' (option 'n')
C
      CALL SSYRK( 'u', 't', n, m, fac, C, NMAX,
     &                   0.0, Cov, KMAX )
      return
      end
