#include <stdio.h>
#include <string.h>
/*                                                  */
/* To use Matlab libray, #define CALLMATLAB         */
/* To turn off Matlab, change #define to #undefine  */
/*                                                  */
#define CALLMATLAB
#ifdef CALLMATLAB
#include "matlab.h"
#endif
void SaveToMat(float *Array, char *matfile, char *varname, int len);
double *newarray_double(int dim1, char *sub, char *msg);
void CError(char *sub, char *msg);

/*                                                              */
/*  C routine for saving a vector to a Matlab .mat file         */
/*                                                              */
   void SaveToMat(float *Array, char *matfile, char *varname, int len){
#ifdef CALLMATLAB
/*                                                              */
/*   Saves single precision array Array to the .mat file whose  */
/*   name is stored in matfile.  The character array varname    */
/*   specifies the name that Array will be saved as in the file */
/*   The integer len is the length of Array (if Array is m-by-  */
/*   n, then len should be m*n                                  */
/*                                                              */
	/* local C variables */
    double *Array2;
    int j;
	/* Local MATALB variables */
    mxArray *volatile vec=NULL;/* matlab array */

    mlfEnterNewContext(0,0); /* Starts MATLAB-like memory management */
                               
    printf("Converting to real to double\n");
    Array2= newarray_double(len, "SavetoMat", "Unable to create Array2");
    for(j=0;j<len;j++){
    	Array2[j]=Array[j];
    }
    
    printf("Converting to matlab\n");
    mlfAssign(&vec,mlfDoubleMatrix(len,1,Array2,NULL));

	/* Destroy all local MATLAB variables except return value (pc) */
    printf("Saving to %s with variable name %s\n",matfile, varname);
    mlfSave(mxCreateString(matfile),"u",varname,vec,NULL);
            
    mxDestroyArray(vec);

    mlfRestorePreviousContext(0,0); /* Stops MATLAB-like memory management */
    									 /* 1 input (latent), 1 output (x)      */
    printf("done\n");
    
#else
	/* Version if MATLAB not available--Only saves a text file */
    /* Saves the length-m array Array in a file called matfile */
    FILE *FIL;
    char msg[150];
    int j;
    
    FIL=fopen(matfile,"w");
    if(FIL==NULL){
        /* Unable to open file.  Return an CError */
        sprintf(msg, "Unable to open file: %s", matfile);
        CError("PrintArray",msg);
    }
    for(j=0;j<len;j++){
        fprintf(FIL, "%f\n",Array[j]);
    }
    fclose(FIL);
#endif
}

double *newarray_double(int dim1, char *sub, char *msg){
  /* returns a pointer to a new dim1 array of doubles         */
  /*                                                          */
  /* Initializes array to 0                                   */

    double *ar, *ptr;
    int j;

    ar=malloc(sizeof(double)*(dim1));
    if(ar==NULL){
      CError(sub, msg);
    }
    ptr=ar;
      for(j=0; j<dim1; j++){
        *ptr=0.0;
        ptr++;
      }
    return(ar);
  }


void CError(char *subrout, char *msg){
    
      printf("CError in function %s: \n", subrout);
      printf("       %s\n", msg);
      exit(-1);
      
  }
  
