C***********************************************************************
C***********************************************************************
C
C Main Program for Fpca
C
C***********************************************************************
C***********************************************************************
      PROGRAM Fpca
      
C Declaring implicit none forces us to declare variables
      implicit none

C FORTRAN array-lengths are set at compile time, so we
C need to set the max value of m  
		INTEGER KMAX
      PARAMETER(KMAX=20)  
		INTEGER NMAX
      PARAMETER(NMAX=100) 
   
C Array to hold the name of the commfile
      CHARACTER*72 filename, sub, msg,name1,name2,name3
      integer j, m, n,INFO
      real C(NMAX,KMAX),Cov(KMAX,KMAX)
		real pct(KMAX),v(KMAX),PC(NMAX), WORK(3*KMAX)
      real sum
      WRITE(*,*)' '
      WRITE(*,*)'Welcome to Fpca'
      WRITE(*,*)' '
C
C FORTRAN provides no way of using command line arguments, so 
C we have to ask the user for the file name
C
      WRITE(*,*)'Enter the name of the data file:  '
      READ (*,'(a)') filename
C Read the commfile
      CALL ReadData(filename, m, n, C, NMAX, KMAX)
      name1='C.txt'
      CALL PrintMat(name1, C, m,n,NMAX) 
C
C Compute the Covariance Matrix
      CALL GetCov(Cov,C,m,n, NMAX, KMAX)
      
		name2='Cov.txt'
      CALL PrintMat(name2, Cov, n,n,KMAX) 
C
C Get the eigenvalues/eigenvectors

C		CALL LAPACK Single Prec. Symmetric Eigenroutine
C 
C  The LAPACK routine SSYEV computes the eigenvectors
C  and eigenvalues of the covariance matrix.
C  Parameters:
C    'V'=save the eigenvalues (in Cov)
C    'U'=Cov is upper-triangular
C     n = size of matrix (Cov)
C    Cov= the matrix
C   KMAX= storage size of Cov
C    pct= length n (or greater) array for eigenvalues
C   WORK= a work array for SSYEV
C   3*KMAX= size of WORK--from documentation
C  INFO=indicates status of SSYEV (INFO=0 means everything OK)
C
      CALL SSYEV('V','U',n,Cov,KMAX,pct,WORK,3*KMAX,INFO)
      if(INFO .ne. 0) then 
      	write(*,*) 'Possible problem with eigenproblem: ',
     &                   'Info =', INFO
      endif
      sum=0.0
      do j=1,n
      	sum=sum+pct(j)
      enddo
      write(*,*)' '
      write(*,*)' #     Eig         %var'
      do j=1,n
      	write(*,*)j, pct(j), pct(j)/sum
      enddo
      name2='PComp.txt'
      CALL PrintMat(name2, Cov, n,n,KMAX)
C
C Store the last eigenvector in array v
C
      do j=1,n
      	v(j)=Cov(j,n)
      enddo
C
C Multiply C by v to produce leading mode--store in PC
C
		CALL SGEMV('n',m,n,1.0,C,NMAX,v,1, 0.0, PC, 1)
C
C Save PC in PC1.txt
C
		name3='PC1.txt'
		CALL PrintArray(name3,PC,m)
C
C Call C-function SaveToMat in savemat.c
C
C  Should create a MATLAB .mat file, saving PC as a 1D
C  array called PC
C
C          --name of file
		name2='PC.mat'//CHAR(0)
C          --name of variable
      name3='PC'//CHAR(0)
C          --TRIM(name2) removes trailing spaces from string
C          --//CHAR(0) adds a null character to the string
      CALL SaveToMat(PC,name2,name3,m)
      
      STOP
      END        
      
