/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.tools;

import java.util.HashMap;
import java.util.Iterator;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;

class SelectionReface extends Action {
    private Circuit circuit;
    private HashMap oldFacings;
    private Direction newFacing;

    SelectionReface(Circuit circuit, HashMap oldFacings, Direction newFacing) {
        this.circuit = circuit;
        this.oldFacings = oldFacings;
        this.newFacing = newFacing;
    }

    public String getName() {
        return Strings.get("selectionRefaceAction");
    }

    public void doIt(Project proj) {
        Object key = ComponentFactory.FACING_ATTRIBUTE_KEY;
        for(Iterator it = oldFacings.keySet().iterator(); it.hasNext(); ) {
            Component comp = (Component) it.next();
            AttributeSet attrs = comp.getAttributeSet();
            Attribute attr = (Attribute) comp.getFactory().getFeature(key, attrs);
            if(attr != null) {
                attrs.setValue(attr, newFacing);
            }
        }
        circuit.componentsChanged(oldFacings.keySet());
    }

    public void undo(Project proj) {
        Object key = ComponentFactory.FACING_ATTRIBUTE_KEY;
        for(Iterator it = oldFacings.keySet().iterator(); it.hasNext(); ) {
            Component comp = (Component) it.next();
            AttributeSet attrs = comp.getAttributeSet();
            Attribute attr = (Attribute) comp.getFactory().getFeature(key, attrs);
            if(attr != null) {
                attrs.setValue(attr, oldFacings.get(comp));
            }
        }
        circuit.componentsChanged(oldFacings.keySet());
    }
}
