/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.tools;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;

class SelectionAttributeChange extends Action {
    private SelectionAttributes source;
    private Circuit circuit;
    private Set selected;
    private Attribute attr;
    private HashMap oldValues;
    private Object newValue;

    SelectionAttributeChange(SelectionAttributes source, Circuit circuit,
            Set selected, Attribute attr, Object newValue) {
        HashMap old = new HashMap();
        for(Iterator it = selected.iterator(); it.hasNext(); ) {
            Component comp = (Component) it.next();
            AttributeSet attrs = comp.getAttributeSet();
            if(attrs.containsAttribute(attr)) {
                old.put(comp, attrs.getValue(attr));
            }
        }

        this.source = source;
        this.circuit = circuit;
        this.selected = selected;
        this.attr = attr;
        this.oldValues = old;
        this.newValue = newValue;
    }

    public String getName() {
        return Strings.get("selectionAttributeAction");
    }

    public void doIt(Project proj) {
        try {
            source.setListening(false);
            Attribute a = attr;
            Object v = newValue;
            for(Iterator it = selected.iterator(); it.hasNext(); ) {
                Component comp = (Component) it.next();
                AttributeSet attrs = comp.getAttributeSet();
                if(attrs.containsAttribute(a)) attrs.setValue(a, v);
            }
        } finally {
            source.setListening(true);
        }
        circuit.componentsChanged(selected);
    }

    public void undo(Project proj) {
        try {
            source.setListening(false);
            Attribute a = attr;
            HashMap old = oldValues;
            for(Iterator it = selected.iterator(); it.hasNext(); ) {
                Component comp = (Component) it.next();
                if(old.containsKey(comp)) {
                    Object v = old.get(comp);
                    comp.getAttributeSet().setValue(a, v);
                }
            }
        } finally {
            source.setListening(true);
        }
        circuit.componentsChanged(selected);
    }
}
