/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.tools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.AttributeSets;

class FactoryAttributes implements AttributeSet, AttributeListener, Cloneable {
    private Class descBase;
    private FactoryDescription desc;
    private ComponentFactory factory;
    private AttributeSet baseAttrs;
    private ArrayList listeners;
    
    public FactoryAttributes(Class descBase, FactoryDescription desc) {
        this.descBase = descBase;
        this.desc = desc;
        this.factory = null;
        this.baseAttrs = null;
        this.listeners = new ArrayList();
    }
    
    public FactoryAttributes(ComponentFactory factory) {
        this.descBase = null;
        this.desc = null;
        this.factory = factory;
        this.baseAttrs = null;
        this.listeners = new ArrayList();
    }
    
    private AttributeSet getBase() {
        AttributeSet ret = baseAttrs;
        if(ret == null) {
            ComponentFactory fact = factory;
            if(fact == null) {
                fact = desc.getFactory(descBase);
                factory = fact;
            }
            if(fact == null) {
                ret = AttributeSets.EMPTY;
            } else {
                ret = fact.createAttributeSet();
                ret.addAttributeListener(this);
            }
            baseAttrs = ret;
        }
        return ret;
    }

    public void addAttributeListener(AttributeListener l) {
        listeners.add(l);
    }

    public void removeAttributeListener(AttributeListener l) {
        listeners.remove(l);
    }
    
    public Object clone() {
        return getBase().clone();
    }

    public boolean containsAttribute(Attribute attr) {
        return getBase().containsAttribute(attr);
    }

    public Attribute getAttribute(String name) {
        return getBase().getAttribute(name);
    }

    public List getAttributes() {
        return getBase().getAttributes();
    }

    public Object getValue(Attribute attr) {
        return getBase().getValue(attr);
    }

    public boolean isReadOnly(Attribute attr) {
        return getBase().isReadOnly(attr);
    }

    public void setReadOnly(Attribute attr, boolean value) {
        getBase().setReadOnly(attr, value);
    }

    public void setValue(Attribute attr, Object value) {
        getBase().setValue(attr, value);
    }

    public void attributeListChanged(AttributeEvent baseEvent) {
        AttributeEvent e = null;
        for(Iterator it = listeners.iterator(); it.hasNext(); ) {
            AttributeListener l = (AttributeListener) it.next();
            if(e == null) {
                e = new AttributeEvent(this, baseEvent.getAttribute(),
                        baseEvent.getValue());
            }
            l.attributeListChanged(e);
        }
    }

    public void attributeValueChanged(AttributeEvent baseEvent) {
        AttributeEvent e = null;
        for(Iterator it = listeners.iterator(); it.hasNext(); ) {
            AttributeListener l = (AttributeListener) it.next();
            if(e == null) {
                e = new AttributeEvent(this, baseEvent.getAttribute(),
                        baseEvent.getValue());
            }
            l.attributeValueChanged(e);
        }
    }
}
