/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceLogger;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.IntegerFactory;

public class ShiftRegisterLogger extends InstanceLogger {
    public Object[] getLogOptions(InstanceState state) {
        Integer stages = (Integer) state.getAttributeValue(ShiftRegister.ATTR_LENGTH);
        Object[] ret = new Object[stages.intValue()];
        for(int i = 0; i < ret.length; i++) {
            ret[i] = IntegerFactory.create(i);
        }
        return ret;
    }
    
    public String getLogName(InstanceState state, Object option) {
        String inName = (String) state.getAttributeValue(StdAttr.LABEL);
        if(inName == null || inName.equals("")) {
            inName = Strings.get("shiftRegisterComponent")
                + state.getInstance().getLocation();
        }
        if(option instanceof Integer) {
            return inName + "[" + option + "]";
        } else {
            return inName;
        }
    }

    public Value getLogValue(InstanceState state, Object option) {
        BitWidth dataWidth = (BitWidth) state.getAttributeValue(StdAttr.WIDTH);
        if(dataWidth == null) dataWidth = BitWidth.create(0);
        ShiftRegisterData data = (ShiftRegisterData) state.getData();
        if(data == null) {
            return Value.createKnown(dataWidth, 0);
        } else {
            int index = option == null ? 0 : ((Integer) option).intValue(); 
            return data.get(index);
        }
    }
}
