/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.std.memory;

import java.util.List;

import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.AttributeSets;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.IntegerFactory;

class CounterAttributes extends AbstractAttributeSet {
    private AttributeSet base;
    
    public CounterAttributes() {
        base = AttributeSets.fixedSet(new Attribute[] {
                StdAttr.WIDTH, Counter.ATTR_MAX,
                StdAttr.EDGE_TRIGGER,
                StdAttr.LABEL, StdAttr.LABEL_FONT
            }, new Object[] {
                BitWidth.create(8), IntegerFactory.create(0xFF),
                StdAttr.TRIG_RISING,
                "", StdAttr.DEFAULT_LABEL_FONT
            });
    }
    
    public void copyInto(AbstractAttributeSet dest) {
        ((CounterAttributes) dest).base = (AttributeSet) this.base.clone();
    }

    public List getAttributes() {
        return base.getAttributes();
    }

    public Object getValue(Attribute attr) {
        return base.getValue(attr);
    }

    public void setValue(Attribute attr, Object value) {
        Object oldValue = base.getValue(attr);
        if(oldValue == null ? value == null : oldValue.equals(value)) return;

        Integer newMax = null;
        if(attr == StdAttr.WIDTH) {
            BitWidth oldWidth = (BitWidth) base.getValue(StdAttr.WIDTH);
            BitWidth newWidth = (BitWidth) value;
            int oldW = oldWidth.getWidth();
            int newW = newWidth.getWidth();
            Integer oldValObj = (Integer) base.getValue(Counter.ATTR_MAX);
            int oldVal = oldValObj.intValue();
            if(newW > oldW) {
                newMax = IntegerFactory.create(newWidth.getMask());
            } else {
                int v = oldVal & newWidth.getMask();
                if(v != oldVal) {
                    Integer newValObj = IntegerFactory.create(v);
                    base.setValue(Counter.ATTR_MAX, newValObj);
                    fireAttributeValueChanged(Counter.ATTR_MAX, newValObj);
                }
            }
        } else if(attr == Counter.ATTR_MAX) {
            int oldVal = ((Integer) value).intValue();
            BitWidth width = (BitWidth) base.getValue(StdAttr.WIDTH);
            int newVal = oldVal & width.getMask();
            if(newVal != oldVal) value = IntegerFactory.create(newVal);
        }
        base.setValue(attr, value);
        fireAttributeValueChanged(attr, value);
        if(newMax != null) {
            base.setValue(Counter.ATTR_MAX, newMax);
            fireAttributeValueChanged(Counter.ATTR_MAX, newMax);
        }
    }

    public boolean containsAttribute(Attribute attr) {
        return base.containsAttribute(attr);
    }

    public Attribute getAttribute(String name) {
        return base.getAttribute(name);
    }

    public boolean isReadOnly(Attribute attr) {
        return base.isReadOnly(attr);
    }

    public void setReadOnly(Attribute attr, boolean value) {
        base.setReadOnly(attr, value);
    }
}
