/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.std.gates;


import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;

import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.Expressions;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.Icons;

class OddParityGate extends AbstractGateFactory {
    public static OddParityGate FACTORY = new OddParityGate();

    private static final String LABEL = "2k+1";

    private OddParityGate() {
        super("Odd Parity", Strings.getter("oddParityComponent"));
        setRectangularLabel(LABEL);
    }


    public Icon getIconShaped() {
        return getIconRectangular();
    }
    public Icon getIconRectangular() {
        return Icons.getIcon("parityOddGate.gif");
    }
    public Icon getIconDin40700() {
        return getIconRectangular();
    }
    public void paintIconShaped(ComponentDrawContext context,
            int x, int y, AttributeSet attrs) {
        paintIconRectangular(context, x, y, attrs);
    }
    public void paintIconRectangular(ComponentDrawContext context,
            int x, int y, AttributeSet attrs) {
        Graphics g = context.getGraphics();
        g.setColor(Color.black);
        g.drawRect(x + 1, y + 2, 16, 16);
        Font old = g.getFont();
        g.setFont(old.deriveFont(9.0f));
        GraphicsUtil.drawCenteredText(g, "2k", x + 9, y + 6);
        GraphicsUtil.drawCenteredText(g, "+1", x + 9, y + 13);
        g.setFont(old);
    }

    protected boolean shouldDrawShaped(ComponentDrawContext c) {
        return false;
    }

    protected void drawShape(ComponentDrawContext context, AbstractGate gate,
            int x, int y, int width, int height) {
        drawRectangular(context, gate, x, y, width, height);
    }

    protected void drawDinShape(ComponentDrawContext context, AbstractGate gate,
            int x, int y, int width, int height, int inputs) {
        drawRectangular(context, gate, x, y, width, height);
    }

    protected Value computeOutput(Value[] inputs, int num_inputs, AttributeSet attrs) {
        return XorGate.computeOddParity(inputs, num_inputs);
    }

    protected Expression computeExpression(Expression[] inputs, int numInputs) {
        Expression ret = inputs[0];
        for(int i = 1; i < numInputs; i++) {
            ret = Expressions.xor(ret, inputs[i]);
        }
        return ret;
    }
}
