/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.std.gates;

import java.util.Arrays;
import java.util.List;

import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.Library;

public class Gates extends Library {
    private List tools = null;

    public Gates() {
        tools = Arrays.asList(new Object[] {
            new AddTool(Constant.FACTORY),
            new AddTool(NotGate.FACTORY),
            new AddTool(Buffer.FACTORY),
            new AddTool(AndGate.FACTORY),
            new AddTool(OrGate.FACTORY),
            new AddTool(NandGate.FACTORY),
            new AddTool(NorGate.FACTORY),
            new AddTool(XorGate.FACTORY),
            new AddTool(XnorGate.FACTORY),
            new AddTool(OddParityGate.FACTORY),
            new AddTool(EvenParityGate.FACTORY),
            new AddTool(ControlledBuffer.FACTORY_BUFFER),
            new AddTool(ControlledBuffer.FACTORY_INVERTER),
        });
    }

    public String getName() { return "Gates"; }

    public String getDisplayName() { return Strings.get("gatesLibrary"); }

    public List getTools() {
        return tools;
    }
}
