/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.std.arith;

import java.util.List;

import com.cburch.logisim.tools.FactoryDescription;
import com.cburch.logisim.tools.Library;

public class Arithmetic extends Library {
    private static FactoryDescription[] DESCRIPTIONS = {
        new FactoryDescription("Adder", Strings.getter("adderComponent"),
                "adder.gif", "Adder"),
        new FactoryDescription("Subtractor", Strings.getter("subtractorComponent"),
                "subtractor.gif", "Subtractor"),
        new FactoryDescription("Multiplier", Strings.getter("multiplierComponent"),
                "multiplier.gif", "Multiplier"),
        new FactoryDescription("Divider", Strings.getter("dividerComponent"),
                "divider.gif", "Divider"),
        new FactoryDescription("Negator", Strings.getter("negatorComponent"),
                "negator.gif", "Negator"),
        new FactoryDescription("Comparator", Strings.getter("comparatorComponent"),
                "comparator.gif", "Comparator"),
        new FactoryDescription("Shifter", Strings.getter("shifterComponent"),
                "shifter.gif", "Shifter"),
    };
    
    private List tools = null;

    public Arithmetic() { }

    public String getName() { return "Arithmetic"; }

    public String getDisplayName() { return Strings.get("arithmeticLibrary"); }

    public List getTools() {
        if(tools == null) {
            tools = FactoryDescription.getTools(Arithmetic.class, DESCRIPTIONS);
        }
        return tools;
    }
}
