/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.proj;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class Template {
    public static Template createEmpty() {
        String circName = Strings.get("newCircuitName");
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buf.append("<project version=\"1.0\">");
        buf.append(" <circuit name=\"" + circName + "\" />");
        buf.append("</project>");
        return new Template(buf.toString());
    }
    
    public static Template create(Reader reader) {
        char[] buf = new char[4096];
        StringBuffer dest = new StringBuffer();
        while(true) {
            try {
                int nbytes = reader.read(buf);
                if(nbytes < 0) break;
                dest.append(buf, 0, nbytes);
            } catch(IOException e) {
                break;
            }
        }
        return new Template(dest.toString());
    }
    
    private String contents;
    
    private Template(String contents) {
        this.contents = contents;
    }
    
    public Reader createReader() {
        return new StringReader(contents);
    }
}
