/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.legacy;

import java.util.List;

import com.cburch.logisim.tools.FactoryDescription;
import com.cburch.logisim.tools.Library;


public class Legacy extends Library {
    private static FactoryDescription[] DESCRIPTIONS = {
        new FactoryDescription("Logisim 1.0 D Flip-Flop", Strings.getter("dFlipFlopComponent"),
                "dFlipFlop.gif", "DFlipFlop"),
        new FactoryDescription("Logisim 1.0 J-K Flip-Flop", Strings.getter("jkFlipFlopComponent"),
                "jkFlipFlop.gif", "JKFlipFlop"),
        new FactoryDescription("Logisim 1.0 Register", Strings.getter("registerComponent"),
                "register.gif", "Register"),
    };

    private List tools = null;

    public Legacy() { }

    public String getName() { return "Legacy"; }

    public String getDisplayName() { return Strings.get("legacyLibrary"); }

    public List getTools() {
        if(tools == null) {
            tools = FactoryDescription.getTools(Legacy.class, DESCRIPTIONS);
        }
        return tools;
    }
}
