/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.instance;

import java.awt.Font;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Attributes;

public interface StdAttr {
    public static final Attribute FACING
        = Attributes.forDirection("facing", Strings.getter("stdFacingAttr"));

    public static final Attribute WIDTH
        = Attributes.forBitWidth("width", Strings.getter("stdDataWidthAttr"));

    public static final Object TRIG_RISING
        = new AttributeOption("rising", Strings.getter("stdTriggerRising"));
    public static final Object TRIG_FALLING
        = new AttributeOption("falling", Strings.getter("stdTriggerFalling"));
    public static final Object TRIG_HIGH
        = new AttributeOption("high", Strings.getter("stdTriggerHigh"));
    public static final Object TRIG_LOW
        = new AttributeOption("low", Strings.getter("stdTriggerLow"));
    public static final Attribute TRIGGER = Attributes.forOption("trigger",
            Strings.getter("stdTriggerAttr"),
            new Object[] { TRIG_RISING, TRIG_FALLING, TRIG_HIGH, TRIG_LOW });
    public static final Attribute EDGE_TRIGGER = Attributes.forOption("trigger",
            Strings.getter("stdTriggerAttr"),
            new Object[] { TRIG_RISING, TRIG_FALLING });

    public static final Attribute LABEL
        = Attributes.forString("label", Strings.getter("stdLabelAttr"));

    public static final Attribute LABEL_FONT
        = Attributes.forFont("labelfont", Strings.getter("stdLabelFontAttr"));
    public static final Font DEFAULT_LABEL_FONT
        = new Font("SansSerif", Font.PLAIN, 12);
}
