/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.instance;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.EndData;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.proj.Project;

class InstanceStateImpl implements InstanceState {
    private CircuitState circuitState;
    private Component component;
    
    public InstanceStateImpl(CircuitState circuitState, Component component) {
        this.circuitState = circuitState;
        this.component = component;
    }
    
    public void repurpose(CircuitState circuitState, Component component) {
        this.circuitState = circuitState;
        this.component = component;
    }
    
    CircuitState getCircuitState() {
        return circuitState;
    }
    
    public Project getProject() {
        return circuitState.getProject();
    }
    
    public Instance getInstance() {
        if(component instanceof InstanceComponent) {
            return ((InstanceComponent) component).getInstance();
        } else {
            return null;
        }
    }
    
    public InstanceFactory getFactory() {
        if(component instanceof InstanceComponent) {
            InstanceComponent comp = (InstanceComponent) component;
            return (InstanceFactory) comp.getFactory();
        } else {
            return null;
        }
    }
    
    public Object getAttributeValue(Attribute attr) {
        return component.getAttributeSet().getValue(attr);
    }
    
    public Value getPort(int portIndex) {
        EndData data = component.getEnd(portIndex);
        return circuitState.getValue(data.getLocation());
    }
    
    public void setPort(int portIndex, Value value, int delay) {
        EndData end = component.getEnd(portIndex);
        circuitState.setValue(end.getLocation(), value, component, delay);
    }
    
    public InstanceData getData() {
        return (InstanceData) circuitState.getData(component);
    }
    
    public void setData(InstanceData value) {
        circuitState.setData(component, value);
    }
    
    public void fireInvalidated() {
        if(component instanceof InstanceComponent) {
            ((InstanceComponent) component).fireInvalidated();
        }
    }
}
