/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.gui.start;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;

public class SplashScreen extends JWindow implements ActionListener {
    public static final int LIBRARIES = 0;
    public static final int TEMPLATE_CREATE = 1;
    public static final int TEMPLATE_OPEN = 2;
    public static final int TEMPLATE_LOAD = 3;
    public static final int TEMPLATE_CLOSE = 4;
    public static final int GUI_INIT = 5;
    public static final int FILE_CREATE = 6;
    public static final int FILE_LOAD = 7;
    public static final int PROJECT_CREATE = 8;
    public static final int FRAME_CREATE = 9;
    
    private static final int PROGRESS_MAX = 3568;
    private static final boolean PRINT_TIMES = false;
    
    private static class Marker {
        int count;
        String message;
        Marker(int count, String message) {
            this.count = count;
            this.message = message;
        }
    }

    Marker[] markers = new Marker[] {
            new Marker(377, Strings.get("progressLibraries")),
            new Marker(990, Strings.get("progressTemplateCreate")),
            new Marker(1002, Strings.get("progressTemplateOpen")),
            new Marker(1002, Strings.get("progressTemplateLoad")),
            new Marker(1470, Strings.get("progressTemplateClose")),
            new Marker(1478, Strings.get("progressGuiInitialize")),
            new Marker(2114, Strings.get("progressFileCreate")),
            new Marker(2114, Strings.get("progressFileLoad")),
            new Marker(2383, Strings.get("progressProjectCreate")),
            new Marker(2519, Strings.get("progressFrameCreate")),
    };
    boolean inClose = false; // for avoiding mutual recursion
    JProgressBar progress = new JProgressBar(0, PROGRESS_MAX);
    JButton close = new JButton(Strings.get("startupCloseButton"));
    JButton cancel = new JButton(Strings.get("startupQuitButton"));
    long startTime = System.currentTimeMillis();

    public SplashScreen() {
        JPanel imagePanel = About.getImagePanel();
        imagePanel.setBorder(null);

        progress.setStringPainted(true);
        
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(close);
        close.addActionListener(this);
        buttonPanel.add(cancel);
        cancel.addActionListener(this);

        JPanel contents = new JPanel(new BorderLayout());
        contents.add(imagePanel, BorderLayout.NORTH);
        contents.add(progress, BorderLayout.CENTER);
        contents.add(buttonPanel, BorderLayout.SOUTH);
        contents.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        
        Color bg = imagePanel.getBackground();
        contents.setBackground(bg);
        buttonPanel.setBackground(bg);
        setBackground(bg);
        setContentPane(contents);
    }

    public void setProgress(int markerId) {
        Marker marker = markers == null ? null : markers[markerId];
        if(marker instanceof Marker) {
            Marker m = (Marker) marker;
            progress.setString(m.message);
            progress.setValue(m.count);
            if(PRINT_TIMES) {
                System.err.println((System.currentTimeMillis() - startTime) //OK
                        + " " + m.message);
            }
        } else {
            if(PRINT_TIMES) {
                System.err.println((System.currentTimeMillis() - startTime) + " ??"); //OK
            }
        }
    }
    
    public void setVisible(boolean value) {
        if(value) {
            pack();
            Dimension dim = getToolkit().getScreenSize();
            int x = (int) (dim.getWidth() - getWidth()) / 2;
            int y = (int) (dim.getHeight() - getHeight()) / 2;
            setLocation(x, y);
        }
        super.setVisible(value);
    }

    public void close() {
        if(inClose) return;
        inClose = true;
        setVisible(false);
        inClose = false;
        if(PRINT_TIMES) {
            System.err.println((System.currentTimeMillis() - startTime) //OK
                    + " closed");
        }
        markers = null;
    }
    
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if(src == cancel) {
            System.exit(0);
        } else if(src == close) {
            close();
        }
    }
}
