/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.gui.main;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JPanel;
import javax.swing.JLabel;

import com.cburch.logisim.proj.LogisimPreferences;

class CoordinateControl extends JPanel implements MouseMotionListener, PropertyChangeListener {
    
    private Canvas canvas;
    private JLabel label;
    private int x, y;

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if(prop.equals(LogisimPreferences.SHOW_COORDINATES)) {
            this.setVisible(LogisimPreferences.getShowCoordinates());
        }
    }

    private void update(int xx, int yy) {
	xx = 10*(((int)(xx + 5))/10);
	yy = 10*(((int)(yy + 5))/10);
	if (xx != x || yy != y) {
	    x = xx;
	    y = yy;
	    label.setText("x="+x+"  y="+y);
	}
    }

    public void mouseDragged(MouseEvent e) { }

    public void mouseMoved(MouseEvent e) {
	update(e.getX(), e.getY());
    }
    
    public CoordinateControl(Canvas canvas) {
        this.canvas = canvas;

        label = new JLabel("x=0  y=0");
        this.add(label);

        canvas.addMouseMotionListener(this);
        LogisimPreferences.addPropertyChangeListener(LogisimPreferences.SHOW_COORDINATES, this);
        this.setVisible(LogisimPreferences.getShowCoordinates());
    }
}
