/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.gui.main;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;

class AttributeChange implements AttributeTableListener {
    private static class SetAction extends Action {
        AttributeSet attrs;
        Attribute attr;
        Object oldValue;
        Object newValue;

        SetAction(AttributeSet as, Attribute a, Object o, Object n) {
            attrs = as;
            attr = a;
            oldValue = o;
            newValue = n;
        }
        public String getName() {
            return Strings.get("changeAttributeAction");
        }
        public void doIt(Project proj) {
            attrs.setValue(attr, newValue);
        }
        public void undo(Project proj) {
            attrs.setValue(attr, oldValue);
        }
    }

    private Project proj;
    
    public AttributeChange(Project proj, AttributeSet attrs) {
        this.proj = proj;
    }

    public void valueChangeRequested(AttributeTable table, AttributeSet attrs,
            Attribute attr, Object value) {
        if(attrs == null) {
            return;
        }
        if(!attrs.containsAttribute(attr)) {
            return;
        }
        Object oldValue = attrs.getValue(attr);
        proj.doAction(new SetAction(attrs, attr, oldValue, value));
    }
}

