/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.gui.main;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.Component;

import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JButton;

import com.cburch.logisim.proj.ProjectEvent;
import com.cburch.logisim.proj.ProjectListener;
import com.cburch.logisim.proj.LogisimPreferences;
import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.circuit.CircuitState;

class ActiveSimulationControl extends JPanel implements PropertyChangeListener, ProjectListener, ActionListener {
    
    private Canvas canvas;
    CircuitState circuitState;

    public void projectChanged(ProjectEvent event) {
	if(event.getAction() == ProjectEvent.ACTION_SET_FILE ||
	    event.getAction() == ProjectEvent.ACTION_SET_CURRENT ||
	    event.getAction() == ProjectEvent.ACTION_SET_STATE) {
	    update();
	}
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if(prop.equals(LogisimPreferences.SHOW_ACTIVE_SIMULATION)) {
            this.setVisible(LogisimPreferences.getShowActiveSimulation());
        }
    }

    public void actionPerformed(ActionEvent e) {
	Component c[] = getComponents();
	CircuitState cs = circuitState;
	if (cs == null) return;
	for (int i = 0; i < c.length; i += 2) {
	    if (e.getSource() == c[i]) {
		int idx = (c.length - i - 1)/2;
		while (idx > 0 && cs.getParentState() != null) {
		    cs = cs.getParentState();
		    idx--;
		}
		if (cs != circuitState)
		    canvas.getProject().setCurrentCircuit(cs.getCircuit());
		return;
	    }
	}
    }

    private void update() {
	Simulator sim = canvas.getProject().getSimulator();
	CircuitState cs = canvas.getProject().getCircuitState();
	if (circuitState == cs)
	    return;
	circuitState = cs;
	removeAll();
	JButton b;
	add(b = new JButton(cs.getCircuit().getName()));
	b.setSelected(true);
	b.addActionListener(this);
	cs = cs.getParentState();
	while (cs != null) {
	    add(new JLabel("::"), 0);
	    add(b = new JButton(cs.getCircuit().getName()), 0);
	    b.setSelected(false);
	    b.addActionListener(this);
	    cs = cs.getParentState();
	}
	validate();
	repaint();
    }

    public ActiveSimulationControl(Canvas canvas) {
        super(new FlowLayout(FlowLayout.LEFT, 2, 2));
        this.canvas = canvas;

        canvas.getProject().addProjectListener(this);
        LogisimPreferences.addPropertyChangeListener(LogisimPreferences.SHOW_ACTIVE_SIMULATION, this);
        this.setVisible(LogisimPreferences.getShowActiveSimulation());

	update();
    }
}
