/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.gui.log;

import java.awt.BorderLayout;

import javax.swing.JPanel;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.data.BitWidth;

class TablePanel extends LogPanel implements ValueTable.Model {

    private class MyListener implements ModelListener {

        public void selectionChanged(ModelEvent event) {
	    table.modelChanged();
	}

        public void entryAdded(ModelEvent event, Value[] values) {
            int oldCount = rowCount; 
            rowCount = computeRowCount();
            if(oldCount == rowCount)
		table.dataChanged();
	    else
		table.modelChanged();
        }
        
        public void filePropertyChanged(ModelEvent event) { }
        
        private int computeRowCount() {
            Model model = getModel();
            Selection sel = model.getSelection();
            int rows = 0;
            for(int i = sel.size() - 1; i >= 0; i--) {
                int x = model.getValueLog(sel.get(i)).size();
                if(x > rows) rows = x;
            }
	    return rows;
        }

    }
    
    private ValueTable table;
    private int rowCount;
    private MyListener myListener = new MyListener();
    
    public TablePanel(LogFrame frame) {
	super(frame);
	table = new ValueTable(getModel() == null ? null : this);
	setLayout(new BorderLayout());
	add(table);
	modelChanged(null, getModel());
    }
    
    public String getTitle() {
        return Strings.get("tableTab");
    }
    
    public String getHelpText() {
        return Strings.get("tableHelp");
    }
    
    public void localeChanged() {
        table.modelChanged();
    }
    
    public void modelChanged(Model oldModel, Model newModel) {
        if(oldModel != null) oldModel.removeModelListener(myListener);
        if(newModel != null) newModel.addModelListener(myListener);
	table.setModel(newModel == null ? null : this);
    }

    public void resetLog() {
	Model model = getModel();
	Selection sel = model.getSelection();
	for(int i = sel.size() - 1; i >= 0; i--)
	    model.getValueLog(sel.get(i)).clear();
	rowCount = 0;
        table.modelChanged();
    }

    // ValueTable.Model implementation
	
    public int getColumnCount()
    {
        Selection sel = getModel().getSelection();
        return sel.size();
    }

    public String getColumnName(int i)
    {
        Selection sel = getModel().getSelection();
	return sel.get(i).toShortString();
    }

    public BitWidth getColumnValueWidth(int i)
    {
        return getModel().getSelection().get(i).getWidth();
    }

    public int getColumnValueRadix(int i) {
        SelectionItem item = getModel().getSelection().get(i);
	return item.getRadix();
    }

    public void changeColumnValueRadix(int i) {
        SelectionItem item = getModel().getSelection().get(i);
	item.changeRadix();
    }

    public int getRowCount()
    {
	return rowCount;
    }

    public void getRowData(int firstRow, int numRows, ValueTable.Cell[][] rowData)
    {
        Selection sel = getModel().getSelection();
	int columns = getColumnCount();
	for (int col = 0; col < columns; col++) {
            ValueLog log = getModel().getValueLog(sel.get(col));
            int offs = rowCount - log.size();
            for(int row = Math.max(offs, firstRow); row < firstRow + numRows; row++) {
                Value val = log.get(row - offs);
		rowData[row-firstRow][col] = new ValueTable.Cell(val, null, null, null);
	    }
	}
    }

}
