/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.circuit;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import com.cburch.logisim.data.Location;

public class WireSet {
    public static final WireSet EMPTY = new WireSet(Collections.EMPTY_SET);
    
    private Set wires;
    private Set points;
    
    WireSet(Set wires) {
        this.wires = wires.isEmpty() ? Collections.EMPTY_SET : wires;
        if(wires.isEmpty()) {
            points = Collections.EMPTY_SET;
        } else {
            points = new HashSet();
            for(Iterator it = wires.iterator(); it.hasNext(); ) {
                Wire w = (Wire) it.next();
                points.add(w.e0);
                points.add(w.e1);
            }
        }
    }
    
    public boolean containsWire(Wire w) {
        return wires.contains(w);
    }
    
    public boolean containsLocation(Location loc) {
        return points.contains(loc);
    }
}
