/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.circuit;

import java.awt.Font;
import java.util.Arrays;
import java.util.List;

import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.instance.StdAttr;

class ProbeAttributes extends AbstractAttributeSet {
    public static ProbeAttributes instance = new ProbeAttributes();

    private static final List ATTRIBUTES = Arrays.asList(new Attribute[] {
        StdAttr.FACING, RadixOption.ATTRIBUTE,
        StdAttr.LABEL, Pin.ATTR_LABEL_LOC, StdAttr.LABEL_FONT,
    });

    Probe component = null;
    Direction facing = Direction.EAST;
    String label = "";
    Direction labelloc = Direction.WEST;
    Font labelfont = StdAttr.DEFAULT_LABEL_FONT;
    RadixOption radix = RadixOption.RADIX_2;

    public ProbeAttributes() { }

    protected void copyInto(AbstractAttributeSet destObj) {
        ProbeAttributes dest = (ProbeAttributes) destObj;
        dest.component = null;
    }

    public List getAttributes() {
        return ATTRIBUTES;
    }

    public Object getValue(Attribute attr) {
        if(attr == StdAttr.FACING) return facing;
        if(attr == StdAttr.LABEL) return label;
        if(attr == Pin.ATTR_LABEL_LOC) return labelloc;
        if(attr == StdAttr.LABEL_FONT) return labelfont;
        if(attr == RadixOption.ATTRIBUTE) return radix;
        return null;
    }

    public void setValue(Attribute attr, Object value) {
        if(attr == StdAttr.FACING) {
            facing = (Direction) value;
        } else if(attr == StdAttr.LABEL) {
            label = (String) value;
        } else if(attr == Pin.ATTR_LABEL_LOC) {
            labelloc = (Direction) value;
        } else if(attr == StdAttr.LABEL_FONT) {
            labelfont = (Font) value;
        } else if(attr == RadixOption.ATTRIBUTE) {
            radix = (RadixOption) value;
        } else {
            throw new IllegalArgumentException("unknown attribute");
        }
        if(component != null) component.attributeValueChanged(this, attr, value);
        fireAttributeValueChanged(attr, value);
    }
}


