/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.logisim.circuit;

import java.util.Arrays;
import java.util.List;

import com.cburch.logisim.comp.EndData;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.instance.StdAttr;

class PinAttributes extends ProbeAttributes {
    public static PinAttributes instance = new PinAttributes();

    private static final List ATTRIBUTES = Arrays.asList(new Attribute[] {
            StdAttr.FACING, Pin.ATTR_TYPE, StdAttr.WIDTH, Pin.ATTR_TRISTATE,
        Pin.ATTR_PULL, StdAttr.LABEL, Pin.ATTR_LABEL_LOC, StdAttr.LABEL_FONT
    });

    BitWidth width = BitWidth.ONE;
    boolean threeState = true;
    int type = EndData.INPUT_ONLY;
    Object pull = Pin.PULL_NONE;

    public PinAttributes() { }

    public List getAttributes() {
        return ATTRIBUTES;
    }

    public Object getValue(Attribute attr) {
        if(attr == StdAttr.WIDTH) return width;
        if(attr == Pin.ATTR_TRISTATE) return threeState ? Boolean.TRUE : Boolean.FALSE;
        if(attr == Pin.ATTR_TYPE) return type == EndData.OUTPUT_ONLY ? Boolean.TRUE : Boolean.FALSE;
        if(attr == Pin.ATTR_PULL) return pull;
        return super.getValue(attr);
    }

    public void setValue(Attribute attr, Object value) {
        if(attr == StdAttr.WIDTH) {
            width = (BitWidth) value;
        } else if(attr == Pin.ATTR_TRISTATE) {
            threeState = ((Boolean) value).booleanValue();
        } else if(attr == Pin.ATTR_TYPE) {
            type = ((Boolean) value).booleanValue() ? EndData.OUTPUT_ONLY : EndData.INPUT_ONLY;
        } else if(attr == Pin.ATTR_PULL) {
            pull = value;
        } else {
            super.setValue(attr, value);
            return;
        }
        if(component != null) component.attributeValueChanged(this, attr, value);
        fireAttributeValueChanged(attr, value);
    }
}


