/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.undo;

class ActionUnion extends Action {
    Action first;
    Action second;

    ActionUnion(Action first, Action second) {
        this.first = first;
        this.second = second;
    }

    public boolean isModification() {
        return first.isModification() || second.isModification();
    }

    public String getName() { return first.getName(); }

    public void doIt() {
        first.doIt();
        second.doIt();
    }

    public void undo() {
        second.undo();
        first.undo();
    }
}
