/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.tools;

import java.awt.Graphics;
import java.util.List;

import javax.swing.Icon;

import com.cburch.draw.canvas.CanvasObject;
import com.cburch.draw.model.Drawables;
import com.cburch.draw.model.DrawingAttribute;
import com.cburch.draw.model.DrawingAttributeSet;
import com.cburch.logisim.util.Icons;

class RoundRectangleTool extends RectangularTool {
    private DrawingAttributeSet attrs;
    
    public RoundRectangleTool(DrawingAttributeSet attrs) {
        this.attrs = attrs;
    }
    
    public Icon getIcon() {
        return Icons.getIcon("drawrrct.gif");
    }
    
    public List getAttributes() {
        return DrawingAttribute.ATTRS_ROUND_RECT;
    }

    public CanvasObject createShape(int x, int y, int w, int h) {
        return Drawables.createRoundRectangle(x, y, w, h, attrs);
    }

    public void drawShape(Graphics g, int x, int y, int w, int h) {
        g.drawRoundRect(x, y, w, h, 10, 10);
    }

    public void fillShape(Graphics g, int x, int y, int w, int h) {
        g.fillRoundRect(x, y, w, h, 10, 10);
    }
}
