/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.tools;

import java.util.List;

import javax.swing.Icon;

import com.cburch.draw.canvas.CanvasObject;
import com.cburch.draw.model.Drawables;
import com.cburch.draw.model.DrawingAttribute;
import com.cburch.draw.model.DrawingAttributeSet;
import com.cburch.logisim.util.Icons;

class PolygonTool extends PolyTool {
    private DrawingAttributeSet attrs;
    
    public PolygonTool(DrawingAttributeSet attrs) {
        this.attrs = attrs;
    }
    
    public Icon getIcon() {
        return Icons.getIcon("drawpoly.gif");
    }
    
    public List getAttributes() {
        return DrawingAttribute.ATTRS_FILL;
    }
    
    protected CanvasObject createShape(List locations) {
        return Drawables.createPolygon(locations, attrs);
    }
}
