/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.model;

import java.awt.Graphics;
import java.util.List;

import com.cburch.logisim.data.Location;

class Rectangle extends Rectangular {
    public Rectangle(int x, int y, int w, int h) {
        super(x, y, w, h);
    }
    
    public String getDisplayName() {
        return Strings.get("shapeRect");
    }

    public List getAttributes() {
        return DrawingAttribute.ATTRS_FILL;
    }
    
    protected boolean contains(int x, int y, int w, int h, Location q) {
        int qx = q.getX();
        int qy = q.getY();
        return qx >= x && qx < x + w && qy >= y && qy < y + h;
    }
    
    public void draw(Graphics g, int x, int y, int w, int h) {
        if(setForFill(g)) g.fillRect(x, y, w, h);
        if(setForStroke(g)) g.drawRect(x, y, w, h);
    }
}
