/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.model;

import java.awt.Graphics;
import java.util.List;

import com.cburch.logisim.data.Location;

class Polyline extends Poly {
    public Polyline(List locations) {
        super(locations);
    }
    
    public String getDisplayName() {
        return Strings.get("shapePolyline");
    }
    
    public List getAttributes() {
        return DrawingAttribute.ATTRS_STROKE;
    }

    public boolean canInsertHandle(int handleIndex) {
        return handleIndex > 0;
    }

    public boolean contains(Location loc) {
        int thresh = Math.max(Line.ON_LINE_THRESH, getStrokeWidth() / 2);
        return ptBorderDistSq(loc) < thresh * thresh;
    }
    
    public void draw(Graphics g, int[] xs, int[] ys) {
        setForStroke(g);
        g.drawPolyline(xs, ys, xs.length);
    }
}