/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.model;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Location;

class Polygon extends Poly {
    private GeneralPath path;
    private Color fillColor;
    
    public Polygon(List locations) {
        super(locations);
        fillColor = Color.WHITE;
    }
    
    public String getDisplayName() {
        return Strings.get("shapePolygon");
    }
    
    public List getAttributes() {
        return DrawingAttribute.ATTRS_FILL;
    }
    
    public Object getValue(Attribute attr) {
        if(attr == DrawingAttribute.FILL_COLOR) {
            return fillColor;
        } else {
            return super.getValue(attr);
        }
    }
    
    public void setAttrValue(Attribute attr, Object value) {
        if(attr == DrawingAttribute.FILL_COLOR) {
            fillColor = (Color) value;
        } else {
            super.setAttrValue(attr, value);
        }
    }
    
    public boolean contains(Location loc) {
        if(path.contains(loc.getX(), loc.getY())) return true;
        int width = getStrokeWidth();
        return ptBorderDistSq(loc) < (width * width) / 4; 
    }

    protected void recomputeBounds() {
        super.recomputeBounds();
        ArrayList locs = new ArrayList();
        getHandles(locs);
        GeneralPath newPath = new GeneralPath();
        if(locs.size() > 0) {
            Location first = (Location) locs.get(0);
            newPath.moveTo(first.getX(), first.getY());
            for(int i = 1, n = locs.size(); i < n; i++) {
                Location loc = (Location) locs.get(i);
                newPath.lineTo(loc.getX(), loc.getY());
            }
        }
        path = newPath;
    }
    
    public void draw(Graphics g, int[] xs, int[] ys) {
        if(fillColor.getAlpha() != 0) {
            g.setColor(fillColor);
            g.fillPolygon(xs, ys, xs.length);
        }
        if(setForStroke(g)) g.drawPolygon(xs, ys, xs.length);
    }
}