/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.model;

import java.awt.Graphics;
import java.util.List;

import com.cburch.logisim.data.Location;

class Oval extends Rectangular {
    public Oval(int x, int y, int w, int h) {
        super(x, y, w, h);
    }
    
    public String getDisplayName() {
        return Strings.get("shapeOval");
    }

    public List getAttributes() {
        return DrawingAttribute.ATTRS_FILL;
    }

    protected boolean contains(int x, int y, int w, int h, Location q) {
        int qx = q.getX();
        int qy = q.getY();
        if(qx >= x && qx < x + w && qy >= y && qy < y + h) {
            double dx = qx - (x + 0.5 * w);
            double dy = qy - (y + 0.5 * h);
            double sum = (dx * dx) / (w * w) + (dy * dy) / (h * h);
            return sum <= 0.25;
        } else {
            return false;
        }
    }
    
    public void draw(Graphics g, int x, int y, int w, int h) {
        if(setForFill(g)) g.fillOval(x, y, w, h);
        if(setForStroke(g)) g.drawOval(x, y, w, h);
    }
}
