/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.model;

import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.util.IntegerFactory;

public class DrawingAttribute {
    public static final AttributeOption ALIGN_START
        = new AttributeOption("start", Strings.getter("alignStart"));
    public static final AttributeOption ALIGN_MIDDLE
        = new AttributeOption("middle", Strings.getter("alignMiddle"));
    public static final AttributeOption ALIGN_END
        = new AttributeOption("end", Strings.getter("alignEnd"));

    public static final Attribute FONT
        = Attributes.forFont("font", Strings.getter("attrFont"));
    public static final Attribute ALIGNMENT
        = Attributes.forOption("align", Strings.getter("attrAlign"),
            new AttributeOption[] { ALIGN_START, ALIGN_MIDDLE, ALIGN_END });
    public static final Attribute STROKE_WIDTH
        = Attributes.forIntegerRange("stroke-width", Strings.getter("attrStrokeWidth"), 0, 8);
    public static final Attribute STROKE_COLOR
        = Attributes.forColor("stroke", Strings.getter("attrStroke"));
    public static final Attribute FILL_COLOR
        = Attributes.forColor("fill", Strings.getter("attrFill"));
    public static final Attribute CORNER_RADIUS
        = Attributes.forIntegerRange("rx", Strings.getter("attrRx"), 1, 10);
    
    static final Color TRANSPARENT = new Color(255, 255, 255, 0);

    public static final List ATTRS_TEXT // for text
        = createAttributes(new Attribute[] { FONT, ALIGNMENT, FILL_COLOR });
    public static final List ATTRS_STROKE // for line, polyline
        = createAttributes(new Attribute[] { STROKE_WIDTH, STROKE_COLOR });
    public static final List ATTRS_FILL // for rectangle, oval, polygon
        = createAttributes(new Attribute[] { STROKE_WIDTH, STROKE_COLOR,
                FILL_COLOR });
    public static final List ATTRS_ROUND_RECT // for rounded rectangle
        = createAttributes(new Attribute[] { STROKE_WIDTH, STROKE_COLOR,
                FILL_COLOR, CORNER_RADIUS });
    static final List ATTRS_ALL
        = createAttributes(new Attribute[] {
                FONT, ALIGNMENT,
                STROKE_WIDTH, STROKE_COLOR,
                FILL_COLOR, CORNER_RADIUS });
    static final List DEFAULTS_ALL
        = Arrays.asList(new Object[] {
                new Font("SansSerif", Font.PLAIN, 12), ALIGN_START,
                IntegerFactory.create(1), Color.BLACK,
                TRANSPARENT, IntegerFactory.create(10) });
    
    private static List createAttributes(Attribute[] values) {
        return Collections.unmodifiableList(Arrays.asList(values));
    }
}
