/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.model;

import java.util.Iterator;
import java.util.List;

import com.cburch.draw.canvas.CanvasObject;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;

public class Drawables {
    private Drawables() { }
    
    public static CanvasObject createLine(int x0, int y0, int x1, int y1,
            AttributeSet attrs) {
        return apply(attrs, new Line(x0, y0, x1, y1));
    }
    
    public static CanvasObject createRectangle(int x, int y, int w, int h,
            AttributeSet attrs) {
        return apply(attrs, new Rectangle(x, y, w, h));
    }
    
    public static CanvasObject createRoundRectangle(int x, int y, int w, int h,
            AttributeSet attrs) {
        return apply(attrs, new RoundRectangle(x, y, w, h));
    }
    
    public static CanvasObject createOval(int x, int y, int w, int h,
            AttributeSet attrs) {
        return apply(attrs, new Oval(x, y, w, h));
    }
    
    public static CanvasObject createPolygon(List locations, AttributeSet attrs) {
        return apply(attrs, new Polygon(locations));
    }
    
    public static CanvasObject createPolyline(List locations, AttributeSet attrs) {
        return apply(attrs, new Polyline(locations));
    }
    
    private static CanvasObject apply(AttributeSet attrs, CanvasObject drawable) {
        DrawingMember d = (DrawingMember) drawable;
        for(Iterator it = attrs.getAttributes().iterator(); it.hasNext(); ) {
            Attribute attr = (Attribute) it.next();
            Object value = attrs.getValue(attr);
            d.setValue(attr, value);
        }
        return drawable;
    }
}
