/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.canvas;

import java.awt.Graphics;
import java.util.List;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;

public interface CanvasObject {
    public abstract String getDisplayName();
    public abstract AttributeSet getAttributeSet();
    public abstract Bounds getBounds();
    public abstract boolean contains(Location loc);
    public abstract void getHandles(List dest);
    public abstract void getHandles(List dest, int handleIndex, int dx, int dy);
    public abstract boolean canInsertHandle(int handleIndex);
    public abstract boolean canDeleteHandle(int handleIndex);
    public abstract void draw(Graphics g, int xOffset, int yOffset);
    public abstract void draw(Graphics g, int xOffset, int yOffset,
            int handleIndex, int handleDx, int handleDy);
}
