/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.canvas;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class CanvasModelEvent extends EventObject {
    public static final int ACTION_ADDED = 0;
    public static final int ACTION_REMOVED = 1;
    public static final int ACTION_TRANSLATED = 2;
    public static final int ACTION_HANDLE_MOVED = 3;
    public static final int ACTION_HANDLE_INSERTED = 4;
    public static final int ACTION_HANDLE_DELETED = 5;
    public static final int ACTION_ATTRIBUTE_CHANGED = 6;
    
    private int action;
    private Collection affected;
    private Map oldValues;
    private Map newValues;
    private int index;
    private int dx;
    private int dy;
    
    public CanvasModelEvent(CanvasModel source, int action, Collection affected) {
        this(source, action, affected, 0, 0, 0);
    }
    
    public CanvasModelEvent(CanvasModel source, int action, Collection affected,
            int index) {
        this(source, action, affected, index, 0, 0);
    }
    
    public CanvasModelEvent(CanvasModel source, int action, Collection affected,
            int dx, int dy) {
        this(source, action, affected, 0, dx, dy);
    }
    
    public CanvasModelEvent(CanvasModel source, int action, Collection affected,
            int index, int dx, int dy) {
        super(source);
        this.action = action;
        this.affected = new HashSet(affected);
        this.index = index;
        this.dx = dx;
        this.dy = dy;
        this.oldValues = null;
        this.newValues = null;
    }
    
    public CanvasModelEvent(CanvasModel source, int action,
            Map oldValues, Map newValues) {
        super(source);
        
        Map oldValuesCopy = Collections.unmodifiableMap(new HashMap(oldValues));
        Map newValuesCopy = Collections.unmodifiableMap(new HashMap(newValues));

        this.action = action;
        this.affected = null;
        this.index = 0;
        this.dx = 0;
        this.dy = 0;
        this.oldValues = oldValuesCopy;
        this.newValues = newValuesCopy;
    }
    
    public int getAction() {
        return action;
    }
    
    public Collection getAffected() {
        Collection ret = affected;
        if(ret == null) {
            Map newVals = newValues;
            if(newVals != null) {
                ret = new HashSet();
                for(Iterator it = newVals.keySet().iterator(); it.hasNext(); ) {
                    AttributeMapKey key = (AttributeMapKey) it.next();
                    ret.add(key.getObject());
                }
                ret = Collections.unmodifiableCollection(ret);
                affected = ret;
            }
        }
        return affected;
    }
    
    public int getIndex() {
        return index;
    }
    
    public int getDeltaX() {
        return dx;
    }
    
    public int getDeltaY() {
        return dy;
    }
    
    public Map getOldValues() {
        return oldValues;
    }
    
    public Map getNewValues() {
        return newValues;
    }
}
