/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.canvas;

import java.awt.Graphics;
import java.util.Collection;
import java.util.Map;

import com.cburch.draw.undo.Action;
import com.cburch.logisim.data.Bounds;

public interface CanvasModel {
    // listener methods
    public void addCanvasModelListener(CanvasModelListener l);
    public void removeCanvasModelListener(CanvasModelListener l);
    
    // methods that don't change any data in the model
    public void paint(Graphics g, Selection selection);
    public CanvasObject getObjectAt(int x, int y);
    public Collection getObjectsIn(Bounds bds);

    // methods for altering pieces of the model
    public void doAction(Action action);
    public void addObjects(Collection shapes);
    public void removeObjects(Collection shapes);
    public void translateObjects(Collection shapes, int dx, int dy);
    public void moveHandle(CanvasObject shape, int index, int dx, int dy);
    public void insertHandle(CanvasObject shape, int index);
    public void deleteHandle(CanvasObject shape, int index);
    public void setAttributeValues(Map values);
}
