/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.canvas;

import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.JComponent;


public class Canvas extends JComponent {
    public static final String TOOL_PROPERTY = "tool";
    public static final String MODEL_PROPERTY = "model";
    
    private CanvasModel model;
    private CanvasListener listener;
    private Selection selection;
    
    public Canvas() {
        model = null;
        listener = new CanvasListener(this);
        selection = new Selection();
        
        addMouseListener(listener);
        addMouseMotionListener(listener);
        addKeyListener(listener);
        setPreferredSize(new Dimension(200, 200));
    }

    public CanvasModel getModel() {
        return model;
    }
    
    public CanvasTool getTool() {
        return listener.getTool();
    }
    
    public Selection getSelection() {
        return selection;
    }
    
    public void setModel(CanvasModel value) {
        CanvasModel oldValue = model;
        if(oldValue != value) {
            if(oldValue != null) oldValue.removeCanvasModelListener(listener);
            model = value;
            if(value != null) value.addCanvasModelListener(listener);
            selection.clearSelected();
            repaint();
            firePropertyChange(TOOL_PROPERTY, oldValue, value);
        }
    }
    
    public void setTool(CanvasTool value) {
        CanvasTool oldValue = listener.getTool();
        if(value != oldValue) {
            listener.setTool(value);
            firePropertyChange(TOOL_PROPERTY, oldValue, value);
        }
    }
    
    public void paintComponent(Graphics g) {
        CanvasModel model = this.model;
        CanvasTool tool = listener.getTool();
        g.clearRect(0, 0, getWidth(), getHeight());
        if(model != null) {
            Graphics dup = g.create();
            model.paint(g, selection);
            dup.dispose();
        }
        if(tool != null) {
            Graphics dup = g.create();
            tool.draw(this, dup);
            dup.dispose();
        }
    }
}
