/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.actions;

import java.util.Collection;
import java.util.HashSet;

import com.cburch.draw.canvas.CanvasModel;
import com.cburch.draw.undo.Action;

public class ModelTranslateAction extends ModelAction {
    private HashSet moved;
    private int dx;
    private int dy;
    
    public ModelTranslateAction(CanvasModel model, Collection moved,
            int dx, int dy) {
        super(model);
        this.moved = new HashSet(moved);
        this.dx = dx;
        this.dy = dy;
    }

    public String getName() {
        return Strings.get("actionTranslate", getShapesName(moved));
    }
    
    void doSub(CanvasModel model) {
        model.translateObjects(moved, dx, dy);
    }
    
    void undoSub(CanvasModel model) {
        model.translateObjects(moved, -dx, -dy);
    }
    
    public boolean shouldAppendTo(Action other) {
        if(other instanceof ModelTranslateAction) {
            ModelTranslateAction o = (ModelTranslateAction) other;
            return this.moved.equals(o.moved);
        } else {
            return false;
        }
    }
    
    public Action append(Action other) {
        if(other instanceof ModelTranslateAction) {
            ModelTranslateAction o = (ModelTranslateAction) other;
            if(this.moved.equals(o.moved)) {
                return new ModelTranslateAction(getModel(), moved,
                        this.dx + o.dx, this.dy + o.dy);
            }
        }
        return super.append(other);
    }
}
