/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import com.cburch.draw.canvas.CanvasModel;
import com.cburch.draw.canvas.CanvasObject;

public class ModelRemoveAction extends ModelAction {
    private ArrayList removed;

    public ModelRemoveAction(CanvasModel model, CanvasObject removed) {
        this(model, Collections.singleton(removed));
    }   
    
    public ModelRemoveAction(CanvasModel model, Collection removed) {
        super(model);
        this.removed = new ArrayList(removed);
    }

    public String getName() {
        return Strings.get("actionRemove", getShapesName(removed));
    }
    
    void doSub(CanvasModel model) {
        model.removeObjects(removed);
    }
    
    void undoSub(CanvasModel model) {
        model.addObjects(removed);
    }
}
