/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.actions;

import com.cburch.draw.canvas.CanvasModel;
import com.cburch.draw.canvas.CanvasObject;
import com.cburch.draw.undo.Action;

public class ModelMoveHandleAction extends ModelAction {
    private CanvasObject shape;
    private int index;
    private int dx;
    private int dy;
    
    public ModelMoveHandleAction(CanvasModel model, CanvasObject shape,
            int index, int dx, int dy) {
        super(model);
        this.shape = shape;
        this.index = index;
        this.dx = dx;
        this.dy = dy;
    }

    public String getName() {
        return Strings.get("actionMoveHandle");
    }
    
    void doSub(CanvasModel model) {
        model.moveHandle(shape, index, dx, dy);
    }
    
    void undoSub(CanvasModel model) {
        model.moveHandle(shape, index, -dx, -dy);
    }
    
    public boolean shouldAppendTo(Action other) {
        if(other instanceof ModelMoveHandleAction) {
            ModelMoveHandleAction o = (ModelMoveHandleAction) other;
            return this.shape == o.shape && this.index == o.index;
        } else {
            return false;
        }
    }
    
    public Action append(Action other) {
        if(other instanceof ModelMoveHandleAction) {
            ModelMoveHandleAction o = (ModelMoveHandleAction) other;
            if(this.shape == o.shape && this.index == o.index) {
                return new ModelMoveHandleAction(getModel(), this.shape,
                        this.index, this.dx + o.dx, this.dy + o.dy);
            }
        }
        return super.append(other);
    }
}