/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.actions;

import com.cburch.draw.canvas.CanvasModel;
import com.cburch.draw.canvas.CanvasObject;

public class ModelInsertHandleAction extends ModelAction {
    private CanvasObject handleObject;
    private int handleIndex;
    
    public ModelInsertHandleAction(CanvasModel model, CanvasObject shape, int index) {
        super(model);
        handleObject = shape;
        handleIndex = index;
    }

    public String getName() {
        return Strings.get("actionDeleteHandle");
    }
    
    void doSub(CanvasModel model) {
        model.insertHandle(handleObject, handleIndex);
    }
    
    void undoSub(CanvasModel model) {
        if(handleObject.canDeleteHandle(handleIndex)) {
            model.deleteHandle(handleObject, handleIndex);
        }
    }
}
