/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.actions;

import java.util.Iterator;
import java.util.Map;

import com.cburch.draw.canvas.AttributeMapKey;
import com.cburch.draw.canvas.CanvasModel;
import com.cburch.logisim.data.Attribute;

public class ModelChangeAttributeAction extends ModelAction {
    private Map oldValues;
    private Map newValues;
    private Attribute attr;
    
    public ModelChangeAttributeAction(CanvasModel model, Map oldValues,
            Map newValues) {
        super(model);
        this.oldValues = oldValues;
        this.newValues = newValues;
    }

    public String getName() {
        Attribute a = attr;
        if(a == null) {
            boolean found = false;
            for(Iterator it = newValues.keySet().iterator(); it.hasNext(); ) {
                AttributeMapKey key = (AttributeMapKey) it.next();
                Attribute at = key.getAttribute();
                if(found) {
                    if(a == null ? at != null : !a.equals(at)) { a = null; break; }
                } else {
                    found = true;
                    a = at;
                }
            }
            attr = a;
        }
        return Strings.get("action", a == null ? "??" : a.getDisplayName());
    }
    
    void doSub(CanvasModel model) {
        model.setAttributeValues(newValues);
    }
    
    void undoSub(CanvasModel model) {
        model.setAttributeValues(oldValues);
    }
}
