/* Copyright (c) 2006, 2009, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */
 
package com.cburch.draw.actions;

import java.util.Collection;

import com.cburch.draw.canvas.CanvasModel;
import com.cburch.draw.canvas.CanvasObject;
import com.cburch.draw.undo.Action;

abstract class ModelAction extends Action {
    private CanvasModel model;
    
    public ModelAction(CanvasModel model) {
        this.model = model;
    }

    public abstract String getName();
    abstract void doSub(CanvasModel model);
    abstract void undoSub(CanvasModel model);

    public final void doIt() {
        doSub(model);
    }

    public final void undo() {
        undoSub(model);
    }
    
    public CanvasModel getModel() {
        return model;
    }
    
    static String getShapesName(Collection coll) {
        if(coll.size() != 1) {
            return Strings.get("shapeMultiple");
        } else {
            CanvasObject shape = (CanvasObject) coll.iterator().next();
            return shape.getDisplayName();
        }
    }
}
