using System;
using System.Drawing;
using System.Windows.Forms;

using UW.ClassroomPresenter.Model.Viewer;

namespace UW.ClassroomPresenter.Viewer.PropertiesForm {

    /// <summary>
    /// Properties page for toolbar customization
    /// </summary>
    public class ToolbarPropertiesPage : TabPage {
        /// <summary>
        /// Constructs a new Toolbar Properties page
        /// </summary>
        public ToolbarPropertiesPage( ViewerStateModel model ) {

            this.SuspendLayout();

            this.Location = new System.Drawing.Point( 4, 22 );
            this.Name = "ToolbarTabPage";
            this.Size = new System.Drawing.Size( 556, 248 );
            this.TabIndex = 50;
            this.Text = Strings.ToolbarProperties;

            // Add the controls
            this.Controls.Add(new ToolbarGroup(model, new Point(16, 24), new Size(508/2, 240), 10, false));
            this.Controls.Add(new ToolbarGroup(model, new Point(32+508/2, 24), new Size(508/2, 240), 30, true));

            this.ResumeLayout();
        }

        /// <summary>
        /// The group box containing the toolbar properties
        /// </summary>
        public class ToolbarGroup : GroupBox {
            /// <summary>
            /// Constructor for the group box
            /// </summary>
            public ToolbarGroup( ViewerStateModel model, Point location, Size size, int tabIndex, bool fullscreen) {

                this.SuspendLayout();

                this.Location = location;
                this.FlatStyle = FlatStyle.System;
                this.Size = size;
                this.TabIndex = tabIndex;
                this.TabStop = false;
                this.Text = fullscreen ? Strings.ToolbarOptionsFullScreen : Strings.ToolbarOptionsMainWindow;
                this.Enabled = true;

                // Add the controls
                int x = 10, y = 0, w = 120;
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20 ), new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.Colors, Strings.Colors));
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20 ), new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.Pen, Strings.PenStylus));
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20 ), new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.Highlighter, Strings.HighlighterStylus));
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20 ), new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.Eraser, Strings.EraserStylus));
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20 ), new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.Cursor, Strings.Cursor));
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20 ), new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.Text, Strings.TextTool));
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20 ), new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.ImageTool, Strings.ImageTool));
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20 ), new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.EraseAll, Strings.EraseAll));
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20 ), new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.Shrink, Strings.Shrink));
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20 ), new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.DuplicateSlide, Strings.DuplicateSlide));

                x += w;
                y = 0;
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20) , new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.Undo, Strings.UndoButton));
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20 ), new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.Redo, Strings.RedoButton));
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20 ), new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.QuickPoll, Strings.QuickPoll));
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20 ), new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.Linked, Strings.Linked));
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20 ), new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.Whiteboard, Strings.WhiteBoard));
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20 ), new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.UpDown, Strings.UpDown));
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20 ), new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.LeftRight, Strings.LeftRight));
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20 ), new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.FullScreen, Strings.FullScreenToggle));
                this.Controls.Add( new ButtonEnabledCheckBox( model, new Point( x, y += 20 ), new Size( w, 24 ), ++tabIndex, fullscreen, ViewerStateModel.ToolbarButtons.Clock, Strings.Clock));

                this.ResumeLayout();
            }

            public class ButtonEnabledCheckBox : CheckBox {
                private ViewerStateModel m_ViewerState;
                private ViewerStateModel.ToolbarButtons m_Button;
                private bool m_Fullscreen;

                /// <summary>
                /// Constructor for the check box
                /// </summary>
                public ButtonEnabledCheckBox( ViewerStateModel model, Point location, Size size, int tabIndex, bool fullscreen, ViewerStateModel.ToolbarButtons b, String name ) {
                    this.m_ViewerState = model;
                    this.m_Button = b;
                    this.m_Fullscreen = fullscreen;

                    this.SuspendLayout();

                    this.FlatStyle = FlatStyle.System;
                    this.Location = location;
                    this.Size = size;
                    this.TabIndex = tabIndex;
                    this.Enabled = true;
                    this.Text = name;
                    
                    // Set the default value according to the model's current setting
                    // NOTE: Split into two steps to avoid deadlock with updating the check state
                    bool bShouldBeChecked = true;

                    if( model != null ) {
                        using( Synchronizer.Lock( model.SyncRoot ) ) {
                            bShouldBeChecked = ((fullscreen ? model.FullScreenButtons : model.MainWindowButtons) & (int)b) != 0;
                        }
                    }

                    this.Checked = bShouldBeChecked;
                    this.CheckState = bShouldBeChecked ? CheckState.Checked : CheckState.Unchecked;

                    this.ResumeLayout();
                }

                protected override void OnCheckedChanged( EventArgs e ) {
                    base.OnCheckedChanged( e );

                    // Update the model value
                    if( this.m_ViewerState != null ) {
                        using( Synchronizer.Lock( this.m_ViewerState.SyncRoot ) ) {
                            if (this.m_Fullscreen)
                            {
                                if (this.Checked)
                                    this.m_ViewerState.FullScreenButtons |= (int)this.m_Button;
                                else
                                    this.m_ViewerState.FullScreenButtons &= ~(int)this.m_Button;
                            }
                            else
                            {
                                if (this.Checked)
                                    this.m_ViewerState.MainWindowButtons |= (int)this.m_Button;
                                else
                                    this.m_ViewerState.MainWindowButtons &= ~(int)this.m_Button;
                            }   
                        }
                    }
                }
            }

        }
    }
}
