/*
 * Decompiled with CFR 0.152.
 */
package cs3410;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.AbstractComponentFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentState;
import com.cburch.logisim.comp.ComponentUserEvent;
import com.cburch.logisim.comp.ManagedComponent;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.tools.AbstractCaret;
import com.cburch.logisim.tools.Caret;
import com.cburch.logisim.tools.Pokable;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

class RegisterFile32
extends ManagedComponent {
    public static final ComponentFactory factory = new Factory();
    static final BitWidth WIDTH = BitWidth.create((int)32);
    static final BitWidth DEPTH = BitWidth.create((int)5);
    static final int NUM_REGISTERS = 32;
    static final int BOX_HEIGHT = 10;
    static final int BOX_WIDTH = 50;
    static final int COL_WIDTH = 65;
    static final int BOX_SEP = 10;
    static final int CHIP_WIDTH = 160;
    static final int CHIP_DEPTH = 180;
    private MyListener myListener = new MyListener();
    static final int P_WDATA = 0;
    static final int P_RDATA1 = 1;
    static final int P_RDATA2 = 2;
    static final int P_WE = 3;
    static final int P_CLK = 4;
    static final int P_WADDR = 5;
    static final int P_RADDR1 = 6;
    static final int P_RADDR2 = 7;
    static final int NUM_PINS = 8;
    static final Value zero = Value.createKnown((BitWidth)WIDTH, (int)0);
    static final Value xxxx = Value.createError((BitWidth)WIDTH);
    static final Value zzzz = Value.createUnknown((BitWidth)WIDTH);
    static /* synthetic */ Class class$0;

    private RegisterFile32(Location loc, AttributeSet attrs) {
        super(loc, attrs, 8);
        int left = -160;
        int right = 0;
        int top = -90;
        int bottom = 90;
        this.setEnd(0, loc.translate(left, -10), WIDTH, 1);
        this.setEnd(1, loc.translate(right, top + 40), WIDTH, 2);
        this.setEnd(2, loc.translate(right, bottom - 40), WIDTH, 2);
        this.setEnd(3, loc.translate(left + 80 - 40, bottom), BitWidth.ONE, 1);
        this.setEnd(4, loc.translate(left, bottom - 10), BitWidth.ONE, 1);
        this.setEnd(5, loc.translate(left + 80 - 10, bottom), DEPTH, 1);
        this.setEnd(6, loc.translate(left + 80 + 30, bottom), DEPTH, 1);
        this.setEnd(7, loc.translate(left + 80 + 50, bottom), DEPTH, 1);
        attrs.addAttributeListener((AttributeListener)this.myListener);
    }

    public Object getFeature(Object key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.cburch.logisim.tools.Pokable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return key == clazz ? this.myListener : super.getFeature(key);
    }

    public ComponentFactory getFactory() {
        return factory;
    }

    Location loc(int pin) {
        return this.getEndLocation(pin);
    }

    Value val(CircuitState s, int pin) {
        return s.getValue(this.loc(pin));
    }

    int addr(CircuitState s, int pin) {
        return this.val(s, pin).toIntValue();
    }

    public void propagate(CircuitState circuitState) {
        Value v1;
        State state = this.getState(circuitState);
        if (state.tick(this.val(circuitState, 4)) && this.val(circuitState, 3) == Value.TRUE) {
            int a = this.addr(circuitState, 5);
            Value v = this.val(circuitState, 0);
            if (a < 0) {
                state.reset(zzzz);
            } else if (a != 0) {
                if (a < 32) {
                    state.R[a] = v;
                } else {
                    throw new IllegalArgumentException("Write address invalid: Please email kwalsh@cs and tell him!");
                }
            }
        }
        int a1 = this.addr(circuitState, 6);
        int a2 = this.addr(circuitState, 7);
        if (a1 >= 32 || a2 >= 32) {
            throw new IllegalArgumentException("Read address invalid: Please email kwalsh@cs and tell him!");
        }
        Value value = a1 < 0 ? zzzz : (v1 = a1 < 32 ? state.R[a1] : xxxx);
        Value v2 = a2 < 0 ? zzzz : (a2 < 32 ? state.R[a2] : xxxx);
        circuitState.setValue(this.loc(1), v1, (Component)this, 9);
        circuitState.setValue(this.loc(2), v2, (Component)this, 9);
    }

    private State getState(CircuitState circuitState) {
        State state = (State)circuitState.getData((Component)this);
        if (state == null) {
            state = new State();
            circuitState.setData((Component)this, (Object)state);
        }
        return state;
    }

    public int boxX(int i) {
        if (i < 16) {
            return 25;
        }
        return 100;
    }

    public int boxY(int i) {
        return (i %= 16) * 10 + 2;
    }

    public void drawBox(Graphics g, Bounds bds, Color color, int i) {
        g.setColor(color);
        g.drawRect(bds.getX() + this.boxX(i), bds.getY() + this.boxY(i), 50, 10);
        g.setColor(Color.BLACK);
    }

    public void draw(ComponentDrawContext context) {
        context.drawRectangle((Component)this);
        context.drawClock((Component)this, 4, Direction.EAST);
        context.drawPin((Component)this, 5);
        context.drawPin((Component)this, 0);
        context.drawPin((Component)this, 3);
        context.drawPin((Component)this, 6);
        context.drawPin((Component)this, 1);
        context.drawPin((Component)this, 7);
        context.drawPin((Component)this, 2);
        Graphics g = context.getGraphics();
        Bounds bds = this.getBounds();
        Font font = g.getFont().deriveFont(9.0f);
        int left = bds.getX();
        int right = bds.getX() + 160;
        int top = bds.getY();
        int bottom = bds.getY() + 180;
        GraphicsUtil.drawText((Graphics)g, (Font)font, (String)"W", (int)(left + 2), (int)(top + 90 - 10), (int)-1, (int)0);
        GraphicsUtil.drawText((Graphics)g, (Font)font, (String)"A", (int)(right - 2), (int)(top + 40), (int)1, (int)0);
        GraphicsUtil.drawText((Graphics)g, (Font)font, (String)"B", (int)(right - 2), (int)(bottom - 40), (int)1, (int)0);
        GraphicsUtil.drawText((Graphics)g, (String)"WE", (int)(left + 80 - 40), (int)(bottom - 1), (int)0, (int)2);
        GraphicsUtil.drawText((Graphics)g, (String)"rW", (int)(left + 80 - 10), (int)(bottom - 1), (int)0, (int)2);
        GraphicsUtil.drawText((Graphics)g, (String)"rA", (int)(left + 80 + 30), (int)(bottom - 1), (int)0, (int)2);
        GraphicsUtil.drawText((Graphics)g, (String)"rB", (int)(left + 80 + 50), (int)(bottom - 1), (int)0, (int)2);
        int i = 0;
        while (i < 32) {
            this.drawBox(g, bds, Color.GRAY, i);
            ++i;
        }
        i = 0;
        while (i < 32) {
            GraphicsUtil.drawText((Graphics)g, (Font)font, (String)("$" + i), (int)(bds.getX() + this.boxX(i) - 1), (int)(bds.getY() + this.boxY(i) + 4), (int)1, (int)0);
            ++i;
        }
        if (!context.getShowState()) {
            return;
        }
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(bds.getX() + this.boxX(0) + 1, bds.getY() + this.boxY(0) + 1, 49, 9);
        g.setColor(Color.BLACK);
        State state = this.getState(context.getCircuitState());
        int i2 = 0;
        while (i2 < 32) {
            int v = state.R[i2].toIntValue();
            String s = state.R[i2].isFullyDefined() ? StringUtil.toHexString((int)WIDTH.getWidth(), (int)v) : "?";
            GraphicsUtil.drawText((Graphics)g, (Font)font, (String)s, (int)(bds.getX() + this.boxX(i2) + 25), (int)(bds.getY() + this.boxY(i2) + 4), (int)0, (int)0);
            ++i2;
        }
    }

    /* synthetic */ RegisterFile32(Location location, AttributeSet attributeSet, RegisterFile32 registerFile32) {
        this(location, attributeSet);
    }

    private static class Factory
    extends AbstractComponentFactory {
        private Factory() {
        }

        public String getName() {
            return "RegisterFile";
        }

        public String getDisplayName() {
            return "Register File";
        }

        public Component createComponent(Location loc, AttributeSet attrs) {
            return new RegisterFile32(loc, attrs, null);
        }

        public Bounds getOffsetBounds(AttributeSet arg0) {
            return Bounds.create((int)-160, (int)-90, (int)160, (int)180);
        }
    }

    private class MyListener
    implements AttributeListener,
    Pokable {
        private MyListener() {
        }

        public void attributeListChanged(AttributeEvent e) {
        }

        public void attributeValueChanged(AttributeEvent e) {
        }

        public Caret getPokeCaret(ComponentUserEvent event) {
            return new PokeCaret(event.getCircuitState());
        }
    }

    private class PokeCaret
    extends AbstractCaret {
        CircuitState circuitState;
        int idx;
        int idx2;

        PokeCaret(CircuitState circuitState) {
            this.circuitState = circuitState;
            this.idx = 0;
            this.setBounds(RegisterFile32.this.getBounds());
        }

        public void draw(Graphics g) {
            if (this.idx < 1) {
                return;
            }
            Bounds bds = RegisterFile32.this.getBounds();
            RegisterFile32.this.drawBox(g, bds, Color.RED, this.idx);
        }

        public void keyTyped(KeyEvent e) {
            int a2;
            Value val;
            State state = RegisterFile32.this.getState(this.circuitState);
            if (this.idx < 1) {
                return;
            }
            int nue = Character.digit(e.getKeyChar(), 16);
            if (nue < 0) {
                return;
            }
            int old = state.R[this.idx].isFullyDefined() ? state.R[this.idx].toIntValue() : 0;
            state.R[this.idx] = val = Value.createKnown((BitWidth)WIDTH, (int)(old << 4 | nue));
            int a1 = RegisterFile32.this.addr(this.circuitState, 6);
            if (a1 == this.idx) {
                this.circuitState.setValue(RegisterFile32.this.loc(1), val, (Component)RegisterFile32.this, 1);
            }
            if ((a2 = RegisterFile32.this.addr(this.circuitState, 7)) == this.idx) {
                this.circuitState.setValue(RegisterFile32.this.loc(2), val, (Component)RegisterFile32.this, 1);
            }
        }

        public void stopEditing() {
        }

        public void cancelEditing() {
        }

        public void mousePressed(MouseEvent e) {
            this.idx2 = this.getRIndex(e.getX(), e.getY());
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            int idx3 = this.getRIndex(e.getX(), e.getY());
            if (idx3 < 1 || this.idx2 != idx3) {
                this.idx = 0;
                return;
            }
            this.idx = idx3;
        }

        public void keyPressed(KeyEvent e) {
            if (this.idx < 0) {
                return;
            }
            switch (e.getKeyCode()) {
                case 40: 
                case 225: {
                    if (this.idx >= 31) break;
                    ++this.idx;
                    break;
                }
                case 39: 
                case 227: {
                    if (this.idx <= 0 || this.idx >= 16) break;
                    this.idx += 16;
                    break;
                }
                case 38: 
                case 224: {
                    if (this.idx <= 1) break;
                    --this.idx;
                    break;
                }
                case 37: 
                case 226: {
                    if (this.idx <= 16) break;
                    this.idx -= 16;
                }
            }
        }

        private int getRIndex(int x, int y) {
            Bounds bds = RegisterFile32.this.getBounds();
            y -= bds.getY();
            if ((x -= bds.getX()) < RegisterFile32.this.boxX(0) - 1 || x > RegisterFile32.this.boxX(31) + 50 + 1) {
                return -1;
            }
            if (x > RegisterFile32.this.boxX(0) + 50 + 1 && x < RegisterFile32.this.boxX(31) - 1) {
                return -1;
            }
            if (y < RegisterFile32.this.boxY(0) || y > RegisterFile32.this.boxY(31) + 10) {
                return -1;
            }
            int i = y / 10;
            if (x > 80) {
                i += 16;
            }
            if (i < 0 || i >= 32) {
                return -1;
            }
            return i;
        }
    }

    private class State
    implements ComponentState,
    Cloneable {
        public Value lastClock = null;
        public Value[] R = new Value[32];

        public State() {
            this.R[0] = zero;
            this.reset(zero);
        }

        public void reset(Value val) {
            int i = 1;
            while (i < 32) {
                this.R[i] = val;
                ++i;
            }
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public boolean tick(Value clk) {
            boolean falling = this.lastClock == Value.TRUE && clk == Value.FALSE;
            this.lastClock = clk;
            return falling;
        }
    }
}

