/*
 * Decompiled with CFR 0.152.
 */
package cs3410;

import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.StringUtil;
import com.cburch.logisim.util.WindowMenuItemManager;
import cs3410.Program32;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class ProgramFrame32
extends JFrame {
    private WindowMenuManager windowManager = new WindowMenuManager();
    private MyListener myListener = new MyListener();
    private Program32.Listing code;
    private ListingModel model;
    private JTable listing;
    private JButton load = new JButton();
    private JButton close = new JButton();

    public ProgramFrame32(Program32.Listing code) {
        this.setDefaultCloseOperation(1);
        this.code = code;
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.load);
        buttonPanel.add(this.close);
        this.load.addActionListener(this.myListener);
        this.close.addActionListener(this.myListener);
        this.setTitle("MIPS Program Listing");
        this.load.setText("Load Program...");
        this.close.setText("Close Window");
        this.model = new ListingModel();
        this.listing = new JTable(this.model);
        this.listing.setAutoResizeMode(3);
        TableColumn tc = this.listing.getColumnModel().getColumn(0);
        tc.setMaxWidth(100);
        tc.setMinWidth(100);
        tc = this.listing.getColumnModel().getColumn(1);
        tc.setMaxWidth(100);
        tc.setMinWidth(100);
        this.listing.setShowHorizontalLines(false);
        this.listing.setShowVerticalLines(true);
        JScrollPane scroll = new JScrollPane(this.listing, 22, 31);
        scroll.setPreferredSize(new Dimension(200, 300));
        Container contents = this.getContentPane();
        contents.add((Component)scroll, "Center");
        contents.add((Component)buttonPanel, "South");
        this.pack();
    }

    public void setVisible(boolean value) {
        if (value && !this.isVisible()) {
            this.windowManager.frameOpened(this);
        }
        super.setVisible(value);
    }

    private class Change
    extends Action {
        int[] old;
        int[] data;
        File file;
        boolean completed = false;

        Change(int[] old, int[] data) {
            this.old = old;
            this.data = data;
        }

        public String getName() {
            return "Load MIPS Program";
        }

        public void doIt(Project proj) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            ProgramFrame32.this.code.setData(this.data);
            Program32.State state = ProgramFrame32.this.code.getState();
            if (state != null) {
                state.codeChanged();
            }
            ProgramFrame32.this.model.fireChanged();
        }

        public void undo(Project proj) {
            if (!this.completed) {
                return;
            }
            this.completed = false;
            ProgramFrame32.this.code.setData(this.old);
            Program32.State state = ProgramFrame32.this.code.getState();
            if (state != null) {
                state.codeChanged();
            }
            ProgramFrame32.this.model.fireChanged();
        }
    }

    private class ListingModel
    extends AbstractTableModel {
        private ListingModel() {
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return ((ProgramFrame32)ProgramFrame32.this).code.src_lines.size();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object getValueAt(int row, int col) {
            try {
                if (col == 0) {
                    Integer i = (Integer)((ProgramFrame32)ProgramFrame32.this).code.addr_map.get(row);
                    if (i == null) {
                        return "";
                    }
                    return StringUtil.toHexString((int)32, (int)i);
                }
                if (col != 1) {
                    return ((ProgramFrame32)ProgramFrame32.this).code.src_lines.get(row);
                }
                Integer i = (Integer)((ProgramFrame32)ProgramFrame32.this).code.addr_map.get(row);
                if (i == null) {
                    return "";
                }
                int instr = ProgramFrame32.this.code.instr(i / 4);
                return StringUtil.toHexString((int)32, (int)instr);
            }
            catch (Exception e) {
                return "???";
            }
        }

        public void fireChanged() {
            this.fireTableStructureChanged();
        }

        public String getColumnName(int col) {
            return col == 0 ? "Address" : "Code";
        }
    }

    private class MyListener
    implements ActionListener {
        private File lastFile = null;

        private MyListener() {
        }

        public void actionPerformed(ActionEvent event) {
            Object src = event.getSource();
            if (src == ProgramFrame32.this.load) {
                JFileChooser chooser = new JFileChooser();
                if (this.lastFile != null) {
                    chooser.setSelectedFile(this.lastFile);
                }
                chooser.setDialogTitle("Load MIPS Program");
                int choice = chooser.showOpenDialog(ProgramFrame32.this);
                if (choice == 0) {
                    File f = chooser.getSelectedFile();
                    try {
                        int[] old = ((ProgramFrame32)ProgramFrame32.this).code.data;
                        ProgramFrame32.this.code.load(f);
                        int[] data = ((ProgramFrame32)ProgramFrame32.this).code.data;
                        Program32.State state = ProgramFrame32.this.code.getState();
                        if (state != null) {
                            state.codeChanged();
                            Project proj = state.getProject();
                            if (proj != null) {
                                proj.doAction((Action)new Change(old, data));
                            }
                        }
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(ProgramFrame32.this, e.getMessage(), "Error loading cs316 program", 0);
                    }
                }
            } else if (src == ProgramFrame32.this.close) {
                WindowEvent e = new WindowEvent(ProgramFrame32.this, 201);
                ProgramFrame32.this.processWindowEvent(e);
            }
        }
    }

    private class WindowMenuManager
    extends WindowMenuItemManager {
        WindowMenuManager() {
            super("MIPS Program Listing", false);
        }

        public JFrame getJFrame(boolean create) {
            return ProgramFrame32.this;
        }
    }
}

