/*
 * Decompiled with CFR 0.152.
 */
package cs3410;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.AbstractComponentFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentState;
import com.cburch.logisim.comp.ComponentUserEvent;
import com.cburch.logisim.comp.ManagedComponent;
import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.tools.Caret;
import com.cburch.logisim.tools.Pokable;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.util.StringUtil;
import cs3410.ProgramFrame32;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

class Program32
extends ManagedComponent {
    static final int NO_OP = 0;
    static final int NUM_ROWS = 5;
    static final int CHIP_WIDTH = 210;
    static final int CHIP_DEPTH = 110;
    public static final ComponentFactory factory = new ProgramFactory("MIPSProgramROM", "MIPS Program ROM", 210, 110);
    static final BitWidth PC_WIDTH = BitWidth.create((int)32);
    static final BitWidth OP_WIDTH = BitWidth.create((int)32);
    static final int BOX_WIDTH = 170;
    static final int ACOL_WIDTH = 52;
    static final int ARROW_WIDTH = 20;
    protected MyListener myListener;
    static final int P_PC = 0;
    static final int P_OP = 1;
    static final int NUM_PINS = 2;
    static final int[] zero = new int[0];
    static Pattern pat0 = Pattern.compile("\\s+");
    static Pattern pat1 = Pattern.compile("\\s*,\\s*");
    static String _reg = "\\$(\\d+)";
    static String __hex = "0x[a-fA-F0-9]+";
    static String __decimal = "-?\\d+";
    static String __label = "[a-zA-Z]\\w*";
    static String _imm = "(" + __hex + "|" + __decimal + "|" + __label + ")";
    static Pattern pat_label = Pattern.compile("(" + __label + ")");
    static HashMap cmds = new HashMap();
    static HashMap opcodes = new HashMap();
    static HashMap fcodes = new HashMap();
    static Pattern pat_arith_imm = Pattern.compile(String.valueOf(_reg) + "," + _reg + "," + _imm);
    static Pattern pat_lui = Pattern.compile(String.valueOf(_reg) + "," + _imm);
    static Pattern pat_mem = Pattern.compile(String.valueOf(_reg) + "," + _imm + "\\(" + _reg + "\\)");
    static Pattern pat_br = Pattern.compile(String.valueOf(_reg) + "," + _reg + "," + _imm);
    static Pattern pat_bz = Pattern.compile(String.valueOf(_reg) + "," + _imm);
    static Pattern pat_j0 = Pattern.compile(_imm);
    static Pattern pat_arith_reg = Pattern.compile(String.valueOf(_reg) + "," + _reg + "," + _reg);
    static Pattern pat_shift_c = Pattern.compile(String.valueOf(_reg) + "," + _reg + "," + _imm);
    static Pattern pat_shift_v = Pattern.compile(String.valueOf(_reg) + "," + _reg + "," + _reg);
    static Pattern pat_jalr = Pattern.compile(String.valueOf(_reg) + "(?:," + _reg + ")?");
    static Pattern pat_jr = Pattern.compile(_reg);
    Project proj;
    static /* synthetic */ Class class$0;

    static {
        new Nop("nop", 0);
        new J("j", 2);
        new J("jal", 3);
        new Br("beq", 4);
        new Br("bne", 5);
        new Bz("blez", 6);
        new Bz("bgtz", 7);
        new ArithImm("addiu", 9);
        new ArithImm("andi", 12);
        new ArithImm("ori", 13);
        new ArithImm("xori", 14);
        new Lui("lui", 15);
        new Mem("lw", 35);
        new Mem("sw", 43);
        new ArithReg("addu", 0, 33);
        new ArithReg("subu", 0, 35);
        new ArithReg("and", 0, 36);
        new ArithReg("or", 0, 37);
        new ArithReg("xor", 0, 38);
        new ArithReg("nor", 0, 39);
        new ShiftConstant("sll", 0, 0);
        new ShiftConstant("srl", 0, 2);
        new ShiftConstant("sra", 0, 3);
        new ShiftVariable("sllv", 0, 4);
        new ShiftVariable("srlv", 0, 6);
        new ShiftVariable("srav", 0, 7);
        new Jr("jr", 0, 8);
        new Jalr("jalr", 0, 9);
    }

    protected Program32(Location loc, AttributeSet attrs) {
        super(loc, attrs, 2);
        this.setEnds(loc);
    }

    protected void setEnds(Location loc) {
        int left = -210;
        int right = 0;
        this.setEnd(0, loc.translate(left, 0), PC_WIDTH, 1);
        this.setEnd(1, loc.translate(right, 0), OP_WIDTH, 2);
        this.myListener = new MyListener();
    }

    public Object getFeature(Object key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.cburch.logisim.tools.Pokable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return key == clazz ? this.myListener : super.getFeature(key);
    }

    public ComponentFactory getFactory() {
        return factory;
    }

    Listing getCode() {
        return (Listing)this.getAttributeSet().getValue(ProgramFactory.CODE_ATTR);
    }

    static String readFully(File file) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(file));
        StringBuffer buf = new StringBuffer();
        while ((line = in.readLine()) != null) {
            buf.append(String.valueOf(line) + "\n");
        }
        return buf.toString();
    }

    static ArrayList splitLines(String src) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new StringReader(src));
        ArrayList<String> buf = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            buf.add(line);
        }
        return buf;
    }

    static ArrayList normalize(ArrayList lines) {
        ArrayList<String> res = new ArrayList<String>();
        int lineno = 0;
        while (lineno < lines.size()) {
            String line = (String)lines.get(lineno);
            int i = line.indexOf(35);
            if (i == 0) {
                line = "";
            } else if (i > 0) {
                line = line.substring(0, i);
            }
            i = line.indexOf(46);
            if (i == 0) {
                line = "";
            } else if (i > 0) {
                line = line.substring(0, i);
            }
            line = line.trim();
            line = pat0.matcher(line).replaceAll(" ");
            line = pat1.matcher(line).replaceAll(",");
            if (line.length() == 0) {
                res.add(null);
            } else {
                res.add(line);
            }
            ++lineno;
        }
        return res;
    }

    static HashMap pass1(ArrayList lines, int start_address, ArrayList addr_map) throws IOException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int addr = start_address;
        addr_map.clear();
        int lineno = 0;
        while (lineno < lines.size()) {
            String line = (String)lines.get(lineno);
            if (line == null) {
                addr_map.add(null);
            } else {
                int i = line.indexOf(58);
                if (i >= 0) {
                    String name = line.substring(0, i).trim();
                    if (name.length() == 0) {
                        throw new IOException("Line " + (lineno + 1) + ": expected label name before ':'");
                    }
                    Matcher m = pat_label.matcher(name);
                    if (name.equalsIgnoreCase("pc") || !m.matches()) {
                        throw new IOException("Line " + (lineno + 1) + ": illegal label name '" + name + "' before ':'");
                    }
                    map.put(name, new Integer(addr));
                    if (i < line.length() - 1) {
                        line = line.substring(i + 1).trim();
                        lines.set(lineno, line);
                        addr_map.add(new Integer(addr));
                        addr += 4;
                    } else {
                        addr_map.add(null);
                        lines.set(lineno, null);
                    }
                } else {
                    addr_map.add(new Integer(addr));
                    addr += 4;
                }
            }
            ++lineno;
        }
        return map;
    }

    static int resolve(int lineno, String imm, int addr, HashMap sym, boolean relative_to_addr) throws IOException {
        int offset = relative_to_addr ? addr + 4 : 0;
        try {
            if (imm.length() == 0) {
                throw new NumberFormatException();
            }
            if (imm.equalsIgnoreCase("pc")) {
                return addr;
            }
            if (imm.startsWith("0x")) {
                return Integer.parseInt(imm.substring(2), 16);
            }
            char c = imm.charAt(0);
            if (c == '-' || c >= '0' && c <= '9') {
                return Integer.parseInt(imm);
            }
            Integer a = (Integer)sym.get(imm);
            if (a != null) {
                return a - offset;
            }
            throw new IOException("Line " + (lineno + 1) + ": label '" + imm + "' not found");
        }
        catch (NumberFormatException e) {
            throw new IOException("Line " + (lineno + 1) + ": invalid argument '" + imm + "', expecting an immediate value");
        }
    }

    static int[] pass2(ArrayList lines, int start_address, HashMap sym) throws IOException {
        int addr = start_address;
        int cnt = 0;
        int lineno = 0;
        while (lineno < lines.size()) {
            String line = (String)lines.get(lineno);
            if (line != null) {
                ++cnt;
            }
            ++lineno;
        }
        int[] code = new int[cnt];
        cnt = 0;
        int lineno2 = 0;
        while (lineno2 < lines.size()) {
            String line = (String)lines.get(lineno2);
            if (line != null) {
                int i = line.indexOf(32);
                String instr = i < 0 ? line : line.substring(0, i);
                String args = i < 0 ? "" : line.substring(i + 1);
                Command cmd = (Command)cmds.get(instr.toLowerCase());
                if (cmd == null) {
                    throw new IOException("Line " + (lineno2 + 1) + ": unrecognized instruction: '" + instr + "'");
                }
                code[cnt++] = cmd.encode(lineno2, addr, args, sym);
                addr += 4;
            }
            ++lineno2;
        }
        return code;
    }

    static int[] assemble(ArrayList src_lines, int start_address, ArrayList addr_map) throws IOException {
        ArrayList lines = Program32.normalize(src_lines);
        HashMap sym = Program32.pass1(lines, start_address, addr_map);
        return Program32.pass2(lines, start_address, sym);
    }

    static String disassemble(int[] code, int start_addr) throws IOException {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < code.length) {
            Command cmd;
            int instr = code[i];
            int op = instr >> 26 & 0x3F;
            if (op == 0) {
                int f = instr & 0x3F;
                cmd = (Command)fcodes.get(new Integer(f));
            } else {
                cmd = (Command)opcodes.get(new Integer(op));
            }
            if (cmd == null) {
                throw new IOException("Instruction " + (i + 1) + " unrecognized: 0x" + Integer.toHexString(instr));
            }
            buf.append(String.valueOf(cmd.decode(start_addr + 4 * i, instr)) + "\n");
            ++i;
        }
        return buf.toString();
    }

    static String disassemble(int instr, int addr) {
        Command cmd;
        int op = instr >> 26 & 0x3F;
        if (op == 0) {
            int f = instr & 0x3F;
            cmd = (Command)fcodes.get(new Integer(f));
        } else {
            cmd = (Command)opcodes.get(new Integer(op));
        }
        if (cmd != null) {
            try {
                return cmd.decode(addr, instr);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "??? <0x" + Integer.toHexString(instr) + ">";
    }

    void setProject(Project p) {
        this.proj = p;
    }

    Location loc(int pin) {
        return this.getEndLocation(pin);
    }

    Value val(CircuitState s, int pin) {
        return s.getValue(this.loc(pin));
    }

    int addr(CircuitState s, int pin) {
        return this.val(s, pin).toIntValue();
    }

    public void propagate(CircuitState circuitState) {
        State state = this.getState(circuitState);
        state.update(this.val(circuitState, 0));
        circuitState.setValue(this.loc(1), Value.createKnown((BitWidth)OP_WIDTH, (int)state.instr()), (Component)this, 9);
    }

    protected State getState(CircuitState circuitState) {
        State state = (State)circuitState.getData((Component)this);
        if (state == null) {
            state = new State(this.getCode());
            circuitState.setData((Component)this, (Object)state);
        }
        return state;
    }

    public void drawBox(Graphics g, Bounds bds, Color color) {
        g.setColor(color);
        g.drawRect(bds.getX() + 20, bds.getY() + 5 + 2, 52, 96);
        g.drawRect(bds.getX() + 20, bds.getY() + 5 + 2, 170, 96);
        g.setColor(Color.BLACK);
    }

    public void drawArrow(Graphics g, Bounds bds, Color color) {
        int left = bds.getX() + 20 - 13;
        int c = bds.getY() + 50 + 5;
        int[] xs = new int[]{left, left + 8, left, left};
        int[] ys = new int[]{c - 5, c, c + 5, c - 5};
        g.setColor(color);
        g.fillPolygon(xs, ys, 4);
        g.setColor(Color.BLACK);
        g.drawPolyline(xs, ys, 4);
    }

    public void draw(ComponentDrawContext context) {
        context.drawRectangle((Component)this);
        Graphics g = context.getGraphics();
        Bounds bds = this.getBounds();
        GraphicsUtil.drawText((Graphics)g, (String)"PC", (int)(bds.getX() + 2), (int)(bds.getY() + 55 - 20), (int)-1, (int)0);
        GraphicsUtil.drawText((Graphics)g, (String)"Op", (int)(bds.getX() + 210 - 2), (int)(bds.getY() + 55), (int)1, (int)0);
        context.drawPin((Component)this, 0);
        context.drawPin((Component)this, 1);
        this.drawBox(g, bds, Color.GRAY);
        if (context.getShowState()) {
            this.drawState(context);
        }
    }

    public void drawState(ComponentDrawContext context) {
        State state = this.getState(context.getCircuitState());
        if (state.code.data.length == 0) {
            return;
        }
        Graphics g = context.getGraphics();
        Bounds bds = this.getBounds();
        this.drawArrow(g, bds, state.badPC() ? Color.YELLOW : Color.BLUE);
        Font font = g.getFont().deriveFont(10.0f);
        int j = -1;
        int i = state.pc - 2;
        while (i <= state.pc + 2) {
            ++j;
            if (!state.badPC(i)) {
                if (i == state.pc) {
                    g.setColor(Color.BLUE);
                }
                GraphicsUtil.drawText((Graphics)g, (Font)font, (String)StringUtil.toHexString((int)32, (int)(i * 4)), (int)(bds.getX() + 20 + 2), (int)(bds.getY() + 20 * j + 10 + 5), (int)-1, (int)0);
                GraphicsUtil.drawText((Graphics)g, (Font)font, (String)state.decode(i), (int)(bds.getX() + 20 + 52 + 1), (int)(bds.getY() + 20 * j + 10 + 5), (int)-1, (int)0);
                if (i == state.pc) {
                    g.setColor(Color.BLACK);
                }
            }
            ++i;
        }
    }

    private static class ArithImm
    extends IType {
        ArithImm(String name, int op) {
            super(name, op);
        }

        int encode(int lineno, int addr, String args, HashMap sym) throws IOException {
            Matcher m = pat_arith_imm.matcher(args);
            if (!m.matches()) {
                throw new IOException("Line " + (lineno + 1) + ": '" + this.name + "' expects $D, $S, imm");
            }
            int imm = Program32.resolve(lineno, m.group(3), addr, sym, false);
            return this.encode(m.group(1), m.group(2), imm, lineno);
        }

        String decode(int addr, int instr) throws IOException {
            return String.valueOf(this.name) + " " + this.rD(instr) + ", " + this.rS(instr) + ", " + this.sImm(instr);
        }
    }

    private static class ArithReg
    extends RType {
        ArithReg(String name, int zero, int f) {
            super(name, zero, f);
        }

        int encode(int lineno, int addr, String args, HashMap sym) throws IOException {
            Matcher m = pat_arith_reg.matcher(args);
            if (!m.matches()) {
                throw new IOException("Line " + (lineno + 1) + ": '" + this.name + "' expects $D, $S, $T");
            }
            return this.encode(m.group(1), m.group(2), m.group(3), 0, lineno);
        }

        String decode(int addr, int instr) throws IOException {
            return String.valueOf(this.name) + " " + this.rD(instr) + ", " + this.rS(instr) + ", " + this.rT(instr);
        }
    }

    private static class Br
    extends IType {
        Br(String name, int op) {
            super(name, op);
        }

        int encode(int lineno, int addr, String args, HashMap sym) throws IOException {
            Matcher m = pat_br.matcher(args);
            if (!m.matches()) {
                throw new IOException("Line " + (lineno + 1) + ": '" + this.name + "' expects offset or label");
            }
            int offset = Program32.resolve(lineno, m.group(3), addr, sym, true);
            if ((offset & 3) != 0) {
                throw new IOException("Line " + (lineno + 1) + ": mis-aligned offset in '" + this.name + "'");
            }
            return this.encode(m.group(2), m.group(1), offset >> 2, lineno);
        }

        String decode(int addr, int instr) throws IOException {
            return String.valueOf(this.name) + " " + this.rS(instr) + ", " + this.rD(instr) + ", " + this.sImm(instr << 2);
        }
    }

    private static class Bz
    extends IType {
        Bz(String name, int op) {
            super(name, op);
        }

        int encode(int lineno, int addr, String args, HashMap sym) throws IOException {
            Matcher m = pat_bz.matcher(args);
            if (!m.matches()) {
                throw new IOException("Line " + (lineno + 1) + ": '" + this.name + "' expects offset or label");
            }
            int offset = Program32.resolve(lineno, m.group(2), addr, sym, true);
            if ((offset & 3) != 0) {
                throw new IOException("Line " + (lineno + 1) + ": mis-aligned offset in '" + this.name + "'");
            }
            return this.encode("0", m.group(1), offset >> 2, lineno);
        }

        String decode(int addr, int instr) throws IOException {
            return String.valueOf(this.name) + " " + this.rS(instr) + ", " + this.sImm(instr << 2);
        }
    }

    private static abstract class Command {
        String name;
        int opcode;

        Command(String name, int op) {
            this.name = name;
            this.opcode = op;
            cmds.put(name, this);
        }

        abstract String decode(int var1, int var2) throws IOException;

        abstract int encode(int var1, int var2, String var3, HashMap var4) throws IOException;
    }

    private static abstract class IType
    extends Command {
        IType(String name, int op) {
            super(name, op);
            opcodes.put(new Integer(op), this);
        }

        int encode(String rd, String rs, int imm, int lineno) throws IOException {
            try {
                int dest = Integer.parseInt(rd);
                int src = Integer.parseInt(rs);
                imm &= 0xFFFF;
                if ((dest & 0x1F) != dest) {
                    throw new IOException("Line " + (lineno + 1) + ": invalid destination register: $" + dest);
                }
                if ((src & 0x1F) != src) {
                    throw new IOException("Line " + (lineno + 1) + ": invalid source register: $" + src);
                }
                return this.opcode << 26 | src << 21 | dest << 16 | imm;
            }
            catch (NumberFormatException e) {
                throw new IOException("Line " + (lineno + 1) + ": invalid arguments to '" + this.name + "': " + e.getMessage());
            }
        }

        String rD(int instr) {
            return "$" + (instr >> 16 & 0x1F);
        }

        String rS(int instr) {
            return "$" + (instr >> 21 & 0x1F);
        }

        String sImm(int instr) {
            return "0x" + Integer.toHexString(instr & 0xFFFF);
        }
    }

    private static class J
    extends Command {
        J(String name, int op) {
            super(name, op);
            opcodes.put(new Integer(op), this);
        }

        int encode(int lineno, int addr, String args, HashMap sym) throws IOException {
            Matcher m = pat_j0.matcher(args);
            if (!m.matches()) {
                throw new IOException("Line " + (lineno + 1) + ": '" + this.name + "' expects address or label");
            }
            int absaddr = Program32.resolve(lineno, m.group(1), addr, sym, false);
            if ((absaddr & 3) != 0) {
                throw new IOException("Line " + (lineno + 1) + ": mis-aligned address in '" + this.name + "'");
            }
            return this.opcode << 26 | absaddr >> 2 & 0x3FFFFFF;
        }

        String decode(int addr, int instr) throws IOException {
            return String.valueOf(this.name) + " 0x" + Integer.toString((instr & 0x3FFFFFF) << 2, 16);
        }
    }

    private static class Jalr
    extends RType {
        Jalr(String name, int zero, int f) {
            super(name, zero, f);
        }

        int encode(int lineno, int addr, String args, HashMap sym) throws IOException {
            Matcher m = pat_jalr.matcher(args);
            if (!m.matches()) {
                throw new IOException("Line " + (lineno + 1) + ": '" + this.name + "' expects $S");
            }
            boolean haveOpt = m.group(2) != null;
            String rd = haveOpt ? m.group(1) : "31";
            String rs = m.group(haveOpt ? 2 : 1);
            return this.encode(rd, rs, "0", 0, lineno);
        }

        String decode(int addr, int instr) throws IOException {
            if ("31".equals(this.rD(instr))) {
                return String.valueOf(this.name) + " " + this.rS(instr);
            }
            return String.valueOf(this.name) + " " + this.rD(instr) + ", " + this.rS(instr);
        }
    }

    private static class Jr
    extends RType {
        Jr(String name, int zero, int f) {
            super(name, zero, f);
        }

        int encode(int lineno, int addr, String args, HashMap sym) throws IOException {
            Matcher m = pat_jr.matcher(args);
            if (!m.matches()) {
                throw new IOException("Line " + (lineno + 1) + ": '" + this.name + "' expects $S");
            }
            return this.encode("0", m.group(1), "0", 0, lineno);
        }

        String decode(int addr, int instr) throws IOException {
            return String.valueOf(this.name) + " " + this.rS(instr);
        }
    }

    static class Listing
    implements Cloneable {
        public String src;
        public int[] data;
        public State state;
        public ArrayList src_lines;
        public ArrayList addr_map;

        public Listing() {
            this.src = "";
            this.data = zero;
            this.addr_map = new ArrayList();
            this.src_lines = new ArrayList();
        }

        public void setListener(State state) {
            this.state = state;
        }

        public void load(File file) throws IOException {
            String s = Program32.readFully(file);
            ArrayList sl = Program32.splitLines(s);
            ArrayList am = new ArrayList();
            this.data = Program32.assemble(sl, 0, am);
            this.src = s;
            this.addr_map = am;
            this.src_lines = sl;
        }

        public void setData(int[] data) {
            this.data = data;
        }

        public State getState() {
            return this.state;
        }

        public Listing(String value) throws IOException {
            this.src = value;
            this.src_lines = Program32.splitLines(this.src);
            this.addr_map = new ArrayList();
            this.data = Program32.assemble(this.src_lines, 0, this.addr_map);
        }

        public String write() throws IOException {
            return this.src;
        }

        int instr(int i) {
            if (i < 0 || i >= this.data.length) {
                return 0;
            }
            return this.data[i];
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    private static class Lui
    extends IType {
        Lui(String name, int op) {
            super(name, op);
        }

        int encode(int lineno, int addr, String args, HashMap sym) throws IOException {
            Matcher m = pat_lui.matcher(args);
            if (!m.matches()) {
                throw new IOException("Line " + (lineno + 1) + ": '" + this.name + "' expects $D, imm");
            }
            int imm = Program32.resolve(lineno, m.group(2), addr, sym, false);
            return this.encode(m.group(1), "0", imm, lineno);
        }

        String decode(int addr, int instr) throws IOException {
            return String.valueOf(this.name) + " " + this.rD(instr) + ", " + this.sImm(instr);
        }
    }

    private static class Mem
    extends IType {
        Mem(String name, int op) {
            super(name, op);
        }

        int encode(int lineno, int addr, String args, HashMap sym) throws IOException {
            Matcher m = pat_mem.matcher(args);
            if (!m.matches()) {
                throw new IOException("Line " + (lineno + 1) + ": '" + this.name + "' expects $D, $S, imm");
            }
            int imm = Program32.resolve(lineno, m.group(2), addr, sym, false);
            return this.encode(m.group(1), m.group(3), imm, lineno);
        }

        String decode(int addr, int instr) throws IOException {
            return String.valueOf(this.name) + " " + this.rD(instr) + ", " + this.sImm(instr) + "(" + this.rS(instr) + ")";
        }
    }

    protected class MyListener
    implements Pokable {
        protected MyListener() {
        }

        public Caret getPokeCaret(ComponentUserEvent event) {
            Canvas canvas = event.getCanvas();
            if (canvas != null) {
                ProgramAttributes attrs = (ProgramAttributes)Program32.this.getAttributeSet();
                Program32.this.setProject(canvas.getProject());
            }
            return null;
        }
    }

    private static class Nop
    extends Command {
        Nop(String name, int op) {
            super(name, op);
        }

        int encode(int lineno, int addr, String args, HashMap sym) throws IOException {
            return 0;
        }

        String decode(int addr, int instr) throws IOException {
            return this.name;
        }
    }

    static class ProgramAttributes
    extends AbstractAttributeSet {
        private static List ATTRIBUTES = Arrays.asList(ProgramFactory.CODE_ATTR);
        private static WeakHashMap windowRegistry = new WeakHashMap();
        private Listing contents = new Listing();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static ProgramFrame32 getProgramFrame(Listing value) {
            WeakHashMap weakHashMap = windowRegistry;
            synchronized (weakHashMap) {
                ProgramFrame32 ret = (ProgramFrame32)windowRegistry.get(value);
                if (ret == null) {
                    ret = new ProgramFrame32(value);
                    ret.setLocationRelativeTo(null);
                    ret.setLocation(300, 200);
                    windowRegistry.put(value, ret);
                }
                return ret;
            }
        }

        ProgramAttributes() {
        }

        protected void copyInto(AbstractAttributeSet dest) {
            ProgramAttributes d = (ProgramAttributes)dest;
            d.contents = (Listing)this.contents.clone();
        }

        public List getAttributes() {
            return ATTRIBUTES;
        }

        public Object getValue(Attribute attr) {
            if (attr == ProgramFactory.CODE_ATTR) {
                return this.contents;
            }
            return null;
        }

        public void setValue(Attribute attr, Object value) {
            if (attr == ProgramFactory.CODE_ATTR) {
                this.contents = (Listing)value;
            }
            this.fireAttributeValueChanged(attr, value);
        }
    }

    protected static class ProgramFactory
    extends AbstractComponentFactory {
        int W;
        int D;
        String N;
        String DN;
        public static Attribute CODE_ATTR = new ContentsAttribute();

        protected ProgramFactory(String n, String dn, int w, int d) {
            this.N = n;
            this.DN = dn;
            this.W = w;
            this.D = d;
        }

        public String getName() {
            return this.N;
        }

        public String getDisplayName() {
            return this.DN;
        }

        public Component createComponent(Location loc, AttributeSet attrs) {
            return new Program32(loc, attrs);
        }

        public Bounds getOffsetBounds(AttributeSet arg0) {
            return Bounds.create((int)(-1 * this.W), (int)(-1 * this.D / 2), (int)this.W, (int)this.D);
        }

        public AttributeSet createAttributeSet() {
            return new ProgramAttributes();
        }

        public void paintIcon(ComponentDrawContext context, int x, int y, AttributeSet attrs) {
            Graphics g = context.getGraphics();
            Font old = g.getFont();
            g.setFont(old.deriveFont(9.0f));
            GraphicsUtil.drawCenteredText((Graphics)g, (String)"ASM", (int)(x + 10), (int)(y + 9));
            g.setFont(old);
            g.drawRect(x, y + 4, 19, 12);
            int dx = 2;
            while (dx < 20) {
                g.drawLine(x + dx, y + 2, x + dx, y + 4);
                g.drawLine(x + dx, y + 16, x + dx, y + 18);
                dx += 5;
            }
        }

        private static class ContentsAttribute
        extends Attribute {
            public ContentsAttribute() {
                super("contents", new StringGetter(){

                    public String get() {
                        return "MIPS Program Listing";
                    }
                });
            }

            public java.awt.Component getCellEditor(Window source, Object value) {
                if (source instanceof Frame) {
                    Project proj = ((Frame)source).getProject();
                    Listing code = (Listing)value;
                    State state = code.getState();
                    if (state != null) {
                        state.setProject(proj);
                    }
                }
                ContentsCell cell = new ContentsCell((Listing)value);
                cell.mouseClicked(null);
                return cell;
            }

            public String toDisplayString(Object value) {
                return "(click to edit)";
            }

            public String toStandardString(Object value) {
                try {
                    return ((Listing)value).write();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "The contents of the Program chip could not be written: " + e.getMessage(), "Error saving cs316 program.", 0);
                    return "";
                }
            }

            public Object parse(String value) {
                try {
                    return new Listing(value);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "The contents of the Program chip could not be read: " + e.getMessage(), "Error loading cs316 program.", 0);
                    return new Listing();
                }
            }
        }

        private static class ContentsCell
        extends JLabel
        implements MouseListener {
            Listing code;

            ContentsCell(Listing code) {
                super("(click here to edit)");
                this.code = code;
                this.addMouseListener(this);
            }

            public void mouseClicked(MouseEvent e) {
                if (this.code == null) {
                    return;
                }
                ProgramFrame32 frame = ProgramAttributes.getProgramFrame(this.code);
                frame.setVisible(true);
                frame.toFront();
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        }
    }

    private static abstract class RType
    extends Command {
        int f;

        RType(String name, int zero, int f) {
            super(name, 0);
            this.f = f;
            fcodes.put(new Integer(f), this);
        }

        int encode(String rd, String rs, String rt, int sa, int lineno) throws IOException {
            try {
                int dest = Integer.parseInt(rd);
                int src = Integer.parseInt(rs);
                int trg = Integer.parseInt(rt);
                if ((dest & 0x1F) != dest) {
                    throw new IOException("Line " + (lineno + 1) + ": invalid destination register: $" + dest);
                }
                if ((src & 0x1F) != src) {
                    throw new IOException("Line " + (lineno + 1) + ": invalid source1 register: $" + src);
                }
                if ((trg & 0x1F) != trg) {
                    throw new IOException("Line " + (lineno + 1) + ": invalid source2 register: $" + trg);
                }
                if ((sa & 0x1F) != sa) {
                    throw new IOException("Line " + (lineno + 1) + ": invalid shift amount: " + sa);
                }
                return this.opcode << 26 | src << 21 | trg << 16 | dest << 11 | sa << 6 | this.f;
            }
            catch (NumberFormatException e) {
                throw new IOException("Line " + (lineno + 1) + ": invalid arguments to '" + this.name + "': " + e.getMessage());
            }
        }

        String rD(int instr) {
            return "$" + (instr >> 11 & 0x1F);
        }

        String rS(int instr) {
            return "$" + (instr >> 21 & 0x1F);
        }

        String rT(int instr) {
            return "$" + (instr >> 16 & 0x1F);
        }

        String sSa(int instr) {
            return "" + (instr >> 6 & 0x1F);
        }
    }

    private static class ShiftConstant
    extends RType {
        ShiftConstant(String name, int zero, int f) {
            super(name, zero, f);
        }

        int encode(int lineno, int addr, String args, HashMap sym) throws IOException {
            Matcher m = pat_shift_c.matcher(args);
            if (!m.matches()) {
                throw new IOException("Line " + (lineno + 1) + ": '" + this.name + "' expects $D, $T, sa");
            }
            int sa = Program32.resolve(lineno, m.group(3), addr, sym, false);
            return this.encode(m.group(1), "0", m.group(2), sa, lineno);
        }

        String decode(int addr, int instr) throws IOException {
            return String.valueOf(this.name) + " " + this.rD(instr) + ", " + this.rT(instr) + ", " + this.sSa(instr);
        }
    }

    private static class ShiftVariable
    extends RType {
        ShiftVariable(String name, int zero, int f) {
            super(name, zero, f);
        }

        int encode(int lineno, int addr, String args, HashMap sym) throws IOException {
            Matcher m = pat_shift_v.matcher(args);
            if (!m.matches()) {
                throw new IOException("Line " + (lineno + 1) + ": '" + this.name + "' expects $D, $T, $S");
            }
            return this.encode(m.group(1), m.group(3), m.group(2), 0, lineno);
        }

        String decode(int addr, int instr) throws IOException {
            return String.valueOf(this.name) + " " + this.rD(instr) + ", " + this.rT(instr) + ", " + this.rS(instr);
        }
    }

    class State
    implements ComponentState,
    Cloneable {
        Listing code;
        public int pc;

        public State(Listing code) {
            this.code = code;
            code.setListener(this);
            this.pc = -1;
        }

        public Project getProject() {
            return Program32.this.proj;
        }

        public void setProject(Project p) {
            Program32.this.proj = p;
        }

        public void codeChanged() {
            if (Program32.this.proj != null) {
                Program32.this.propagate(Program32.this.proj.getCircuitState());
            }
        }

        String decode(int i) {
            return Program32.disassemble(this.code.instr(i), 4 * i);
        }

        int instr() {
            return this.code.instr(this.pc);
        }

        boolean badPC(int i) {
            return i < 0 || i >= this.code.data.length;
        }

        boolean badPC() {
            return this.badPC(this.pc);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public void update(Value pc_in) {
            this.pc = pc_in.toIntValue() / 4;
        }
    }
}

