/*
 * Decompiled with CFR 0.152.
 */
package cs3410;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.AbstractComponentFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ManagedComponent;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.AttributeSets;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import java.awt.Color;
import java.awt.Graphics;

class LED
extends ManagedComponent {
    public static final ComponentFactory factory = new Factory();
    static final String[] COLOR_OPTIONS = new String[]{"Red", "Green", "Yellow", "Blue", "White"};
    public static final Attribute COLOR_OPTION = Attributes.forOption((String)"color", (StringGetter)new StringGetter(){

        public String get() {
            return "Color";
        }
    }, (Object[])COLOR_OPTIONS);
    private static final Attribute[] ATTRIBUTES = new Attribute[]{COLOR_OPTION};

    private LED(Location loc, AttributeSet attrs) {
        super(loc, attrs, 1);
        this.setEnd(0, this.getLocation().translate(-20, 0), BitWidth.ONE, 1);
    }

    public ComponentFactory getFactory() {
        return factory;
    }

    public void propagate(CircuitState state) {
    }

    public void draw(ComponentDrawContext context) {
        Location loc = this.getLocation();
        int size = this.getBounds().getWidth();
        LED.drawLED(context, loc.getX(), loc.getY(), this.getAttributeSet().getValue(COLOR_OPTION), (Component)this, size);
    }

    static void drawLED(ComponentDrawContext context, int x, int y, Object colorName, Component comp, int size) {
        boolean on;
        Graphics g = context.getGraphics();
        boolean bl = on = comp == null || !context.getShowState() || context.getCircuitState().getValue(comp.getEnd(0).getLocation()).toIntValue() == 1;
        if (comp != null) {
            context.drawPin(comp, 0);
        }
        int xoff = comp == null ? 0 : -20;
        int yoff = comp == null ? 0 : -10;
        g.setColor(Color.BLACK);
        g.drawOval(xoff + x, yoff + y, size, size);
        g.setColor(LED.colorFor((String)colorName, on));
        g.fillOval(xoff + x + 2, yoff + y + 2, size - 4, size - 4);
    }

    static Color colorFor(String s, boolean on) {
        if (on) {
            if (s.equalsIgnoreCase("red")) {
                return Color.RED;
            }
            if (s.equalsIgnoreCase("yellow")) {
                return Color.YELLOW;
            }
            if (s.equalsIgnoreCase("green")) {
                return Color.GREEN;
            }
            if (s.equalsIgnoreCase("blue")) {
                return Color.BLUE;
            }
            if (s.equalsIgnoreCase("white")) {
                return Color.WHITE;
            }
        } else {
            return Color.LIGHT_GRAY;
        }
        return Color.DARK_GRAY;
    }

    /* synthetic */ LED(Location location, AttributeSet attributeSet, LED lED) {
        this(location, attributeSet);
    }

    private static class Factory
    extends AbstractComponentFactory {
        private Factory() {
        }

        public String getName() {
            return "LED";
        }

        public String getDisplayName() {
            return "LED";
        }

        public AttributeSet createAttributeSet() {
            return AttributeSets.fixedSet((Attribute[])ATTRIBUTES, (Object[])new Object[]{"Red"});
        }

        public Component createComponent(Location loc, AttributeSet attrs) {
            return new LED(loc, attrs, null);
        }

        public Bounds getOffsetBounds(AttributeSet attrs) {
            return Bounds.create((int)-20, (int)-10, (int)20, (int)20);
        }

        public void paintIcon(ComponentDrawContext context, int x, int y, AttributeSet attrs) {
            LED.drawLED(context, x, y, attrs.getValue(COLOR_OPTION), null, 16);
        }

        public void drawGhost(ComponentDrawContext context, Color color, int x, int y, AttributeSet attrs) {
            Graphics g = context.getGraphics();
            Bounds bds = this.getOffsetBounds(attrs);
            g.setColor(color);
            GraphicsUtil.switchToWidth((Graphics)g, (int)2);
            g.drawOval(x + bds.getX() + 1, y + bds.getY() + 1, bds.getWidth() - 1, bds.getHeight() - 1);
        }
    }
}

