/*
 * Decompiled with CFR 0.152.
 */
package cs3410;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.AbstractComponentFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentState;
import com.cburch.logisim.comp.ComponentUserEvent;
import com.cburch.logisim.comp.ManagedComponent;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.tools.AbstractCaret;
import com.cburch.logisim.tools.Caret;
import com.cburch.logisim.tools.Pokable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

class Keyboard
extends ManagedComponent {
    public static final ComponentFactory factory = new Factory();
    static final BitWidth FIVE = BitWidth.create((int)5);
    static final BitWidth EIGHT = BitWidth.create((int)8);
    static final int P_CLK = 0;
    static final int P_RE = 1;
    static final int P_D = 2;
    static final int P_RST = 3;
    private MyListener myListener = new MyListener();
    static /* synthetic */ Class class$0;

    private Keyboard(Location loc, AttributeSet attrs) {
        super(loc, attrs, 4);
        this.setEnd(0, this.getLocation().translate(-220, 10), BitWidth.ONE, 1);
        this.setEnd(1, this.getLocation().translate(-200, 10), BitWidth.ONE, 1);
        this.setEnd(2, this.getLocation().translate(-120, 10), EIGHT, 1);
        this.setEnd(3, this.getLocation().translate(-240, 10), BitWidth.ONE, 1);
    }

    public ComponentFactory getFactory() {
        return factory;
    }

    public Object getFeature(Object key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.cburch.logisim.tools.Pokable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return key == clazz ? this.myListener : super.getFeature(key);
    }

    Location loc(int pin) {
        return this.getEndLocation(pin);
    }

    Value val(CircuitState s, int pin) {
        return s.getValue(this.loc(pin));
    }

    int addr(CircuitState s, int pin) {
        return this.val(s, pin).toIntValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagate(CircuitState circuitState) {
        byte c;
        State state;
        State state2 = this.getState(circuitState);
        if (state2.tick(this.val(circuitState, 0)) && this.val(circuitState, 1) == Value.TRUE) {
            state = state2;
            synchronized (state) {
                if (state2.buf.length() > 0) {
                    state2.buf = state2.buf.substring(1);
                }
                if (state2.editpos > 0) {
                    --state2.editpos;
                }
            }
        }
        if (this.val(circuitState, 3) == Value.TRUE) {
            state = state2;
            synchronized (state) {
                state2.buf = "";
                if (state2.editpos > 0) {
                    state2.editpos = 0;
                }
            }
        }
        State state3 = state2;
        synchronized (state3) {
            c = state2.buf.length() > 0 ? state2.buf.getBytes()[0] : (byte)0;
        }
        circuitState.setValue(this.loc(2), Value.createKnown((BitWidth)EIGHT, (int)(c & 0xFF)), (Component)this, 1);
    }

    public void draw(ComponentDrawContext context) {
        Location loc = this.getLocation();
        int size = this.getBounds().getWidth();
        State s = this.getState(context.getCircuitState());
        this.drawKeyboard(context, loc.getX(), loc.getY(), s);
    }

    static void drawKeyboardIcon(ComponentDrawContext context, int x, int y) {
        Graphics g = context.getGraphics();
        g.setColor(Color.BLACK);
        g.drawRect(x + 0, y + 2, 15, 9);
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(x + 3, y + 5, 10, 5);
        g.setColor(Color.BLACK);
    }

    void drawKeyboard(ComponentDrawContext context, int x, int y, State state) {
        Graphics g = context.getGraphics();
        g.drawRect(x -= 330, y -= 20, 329, 29);
        context.drawClock((Component)this, 0, Direction.NORTH);
        int i = 1;
        while (i <= 3) {
            context.drawPin((Component)this, i);
            ++i;
        }
        this.drawString(g, x, y, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawString(Graphics g, int x, int y, State state) {
        int editpos;
        String s;
        g.setColor(Color.LIGHT_GRAY);
        State state2 = state;
        synchronized (state2) {
            s = state.buf;
            editpos = state.editpos;
        }
        if (editpos > 31) {
            s = "\u2026" + s.substring(editpos - 30);
            editpos = 31;
        }
        g.setColor(Color.WHITE);
        g.fillRect(x + 3, y + 2, 324, 22);
        g.setColor(Color.LIGHT_GRAY);
        if (s.length() >= 32) {
            g.fillRect(x + 3, y + 2, 324, 22);
        } else if (s.length() > 0) {
            g.fillRect(x + 3, y + 2, 3 + 10 * s.length(), 22);
        }
        if (editpos >= 0) {
            g.setColor(Color.DARK_GRAY);
            g.drawRect(x + 5 + editpos * 10, y + 3, 10, 19);
        }
        g.setColor(Color.BLACK);
        int n = s.length();
        if (n > 32) {
            n = 32;
        }
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            if (c == '\n') {
                g.drawString("\\", x + 6 + i * 10 - 2, y + 18);
                g.drawString("n", x + 6 + i * 10 + 2, y + 18);
            } else {
                g.drawString(s.substring(i, i + 1), x + 6 + i * 10, y + 18);
            }
            ++i;
        }
    }

    private State getState(CircuitState circuitState) {
        State state = (State)circuitState.getData((Component)this);
        if (state == null) {
            state = new State();
            circuitState.setData((Component)this, (Object)state);
        }
        return state;
    }

    /* synthetic */ Keyboard(Location location, AttributeSet attributeSet, Keyboard keyboard) {
        this(location, attributeSet);
    }

    private static class Factory
    extends AbstractComponentFactory {
        private Factory() {
        }

        public String getName() {
            return "Keyboard Queue";
        }

        public String getDisplayName() {
            return "Keyboard Queue";
        }

        public Component createComponent(Location loc, AttributeSet attrs) {
            return new Keyboard(loc, attrs, null);
        }

        public Bounds getOffsetBounds(AttributeSet attrs) {
            return Bounds.create((int)-330, (int)-20, (int)330, (int)30);
        }

        public void paintIcon(ComponentDrawContext context, int x, int y, AttributeSet attrs) {
            Keyboard.drawKeyboardIcon(context, x, y);
        }
    }

    private class MyListener
    implements Pokable {
        private MyListener() {
        }

        public Caret getPokeCaret(ComponentUserEvent event) {
            return new PokeCaret(event.getCircuitState());
        }
    }

    private class PokeCaret
    extends AbstractCaret {
        CircuitState circuitState;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PokeCaret(CircuitState circuitState) {
            State state;
            this.circuitState = circuitState;
            this.setBounds(Keyboard.this.getBounds());
            State state2 = state = Keyboard.this.getState(circuitState);
            synchronized (state2) {
                state.editpos = state.buf.length();
            }
        }

        public void draw(Graphics g) {
            State state = Keyboard.this.getState(this.circuitState);
            Bounds bds = Keyboard.this.getBounds();
            Keyboard.this.drawString(g, bds.getX(), bds.getY(), state);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyTyped(KeyEvent e) {
            State state = Keyboard.this.getState(this.circuitState);
            char c = e.getKeyChar();
            if ((c < ' ' || c > '~') && c != '\n') {
                return;
            }
            char[] a = new char[]{c};
            String s = new String(a);
            State state2 = state;
            synchronized (state2) {
                state.buf = state.editpos == state.buf.length() ? String.valueOf(state.buf) + s : (state.editpos == 0 ? String.valueOf(s) + state.buf : String.valueOf(state.buf.substring(0, state.editpos)) + s + state.buf.substring(state.editpos));
                ++state.editpos;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopEditing() {
            State state;
            State state2 = state = Keyboard.this.getState(this.circuitState);
            synchronized (state2) {
                state.editpos = -1;
            }
        }

        public void cancelEditing() {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(KeyEvent e) {
            State state;
            State state2 = state = Keyboard.this.getState(this.circuitState);
            synchronized (state2) {
                switch (e.getKeyCode()) {
                    case 39: 
                    case 227: {
                        if (state.editpos >= state.buf.length()) break;
                        ++state.editpos;
                        break;
                    }
                    case 37: 
                    case 226: {
                        if (state.editpos <= 0) break;
                        --state.editpos;
                        break;
                    }
                    case 127: {
                        if (state.editpos == state.buf.length()) break;
                        ++state.editpos;
                    }
                    case 8: {
                        if (state.editpos == 0) break;
                        state.buf = state.buf.length() == 1 ? "" : (state.editpos == state.buf.length() ? state.buf.substring(0, state.buf.length() - 1) : String.valueOf(state.buf.substring(0, state.editpos - 1)) + state.buf.substring(state.editpos));
                        --state.editpos;
                    }
                }
            }
        }
    }

    private class State
    implements ComponentState,
    Cloneable {
        public Value lastClock = null;
        public String buf = "";
        public int editpos = -1;

        State() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public boolean tick(Value clk) {
            boolean rising = this.lastClock == null || this.lastClock == Value.FALSE && clk == Value.TRUE;
            this.lastClock = clk;
            return rising;
        }
    }
}

